/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.38")
@CheckID(value="R.1048")
@CheckName(value="R.1048")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.DEAD_CODE})
@CheckTitle(value="Do not repeat unary prefix operators")
@CheckDescription(value="Unary prefix operators should not be repeated.\nThis rule raises an issue for sequences of: +, -, !, ~, &, ~&, |, ~|, ^, ~^ and ^~.\n\nExamples:\nint x = 1;\nint y = ~~~x; // not allowed\nint z = ~~1; // not allowed\nint w = ~x; // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1048
extends OVMComplianceCheck {
    HashSet<String> relevantOperators = new HashSet<String>(Arrays.asList("+", "-", "!", "~", "&", "~&", "|", "~|", "^", "~^", "^~"));
    private final HidOperatorVisitor operatorsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidObject) {
            if (Check_R_1048.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1048.this.notifyCheckAlive();
            if (!(hidObject instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                return true;
            }
            if (!Check_R_1048.this.relevantOperators.contains(operator.getOperatorText())) {
                return true;
            }
            if (!(operator.getLHValue() instanceof RfHidOperator)) {
                return true;
            }
            if (Check_R_1048.this.isTheSameOperator(operator, (RfHidOperator)operator.getLHValue())) {
                Check_R_1048.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Unary prefix operator '" + operator.getOperatorText() + "' is repeated!");
            }
            return true;
        }
    };

    public Check_R_1048(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.operatorsVisitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean isTheSameOperator(RfHidOperator x, RfHidOperator y) {
        if (x.getOperatorText().equals("^~") || x.getOperatorText().equals("~^")) {
            return y.getOperatorText().equals("^~") || y.getOperatorText().equals("~^");
        }
        return x.getOperatorText().equals(y.getOperatorText());
    }
}

