/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1049")
@CheckName(value="R.1049")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Zero should not be a possible denominator")
@CheckDescription(value="This check flags all occurences of zero used as a denominator.\nDivision by 0 can cause unexpected behavior as it returns 0 for 2-state variables and X for 4-state variables.\nExamples: \na = b / 0; // not allowed\na = b / c; // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1049
extends OVMComplianceCheck {
    private final int ZERO = 0;

    public Check_R_1049(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(null, new LocalHidOperatorVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator operator) {
            if (Check_R_1049.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (operator.getOperatorText() == null) {
                return true;
            }
            if (operator.isHidden()) {
                return true;
            }
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return true;
            }
            if (!operator.isDiv() && !operator.isModulo()) {
                return true;
            }
            Check_R_1049.this.notifyCheckAlive();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null) {
                return true;
            }
            if (rhValues.size() != 1) {
                return true;
            }
            IHidObject firstValue = (IHidObject)rhValues.get(0);
            if (!(firstValue instanceof RfHidImplicit)) {
                return true;
            }
            RfHidImplicit rhHidImplicit = (RfHidImplicit)firstValue;
            Number number = rhHidImplicit.parseNumberValue();
            if (number == null) {
                return true;
            }
            int assignedValue = number.intValue();
            if (assignedValue != 0) {
                return true;
            }
            Check_R_1049.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Zero used as denominator in expression '" + HidUtils.toNiceString((IHidObject)operator) + "'!");
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

