/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1050")
@CheckName(value="R.1050")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use '=+' or '=-' instead of '+=' or '-='")
@CheckDescription(value="Using '=+' or '=-' where the reversed was meant will produce unexpected results.\nThis check flags all usages of '=+'/'=-'. It flags the cases when '=+' or '=-' are used without any spacing between the two operators.\n\nExamples:\nint a = 0;\na += 1  // allowed\na = -1  // allowed\na = - 1 // allowed\na =+ 1  // not allowed\na =- 1  // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1050
extends OVMComplianceCheck {
    public Check_R_1050(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(null, new LocalHidOperatorVisitor());
    }

    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator operator) {
            int offset;
            if (Check_R_1050.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1050.this.notifyCheckAlive();
            if (operator.getOperatorText() == null) {
                return true;
            }
            if (operator.isHidden()) {
                return true;
            }
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return true;
            }
            if (!operator.isEqualAssignment()) {
                return true;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return true;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null) {
                return true;
            }
            if (rhValues.size() != 1) {
                return true;
            }
            IHidObject firstValue = (IHidObject)rhValues.get(0);
            if (!(firstValue instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator rightOperator = (RfHidOperator)firstValue;
            if (!rightOperator.isPlus() && !rightOperator.isMinus()) {
                return true;
            }
            if (rightOperator.getReparseInfo() != null) {
                return true;
            }
            int rightOffset = rightOperator.getOccurrence().getOffset();
            if (rightOffset - (offset = operator.getOccurrence().getOffset()) > 1) {
                return true;
            }
            if (rightOffset == offset && operator.getReparseInfo() != null && operator.getReparseInfo().equals(rightOperator.getReparseInfo()) && rightOperator.getVirtualOffset() - operator.getVirtualOffset() > 1) {
                return true;
            }
            Check_R_1050.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Operators '=" + rightOperator.getOperatorText() + "' used in expression '" + HidUtils.toNiceString((IHidObject)operator) + "'!");
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

