/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1051")
@CheckName(value="R.1051")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override the predefined pre- and post- phase methods")
@CheckDescription(value="\nThis check flags the overrides of the pre- and post- phase methods from XVM\nThe predefined run-time phases with the pre_ and post_ prefixes have informal descriptions that are extremely similar to the other predefined phases.\nTo avoid making unwarranted assumptions about the meaning of these phases it is best to confine yourself to overriding the reset, configure, main, and shutdown phases and to add user-defined phases in other cases.\n\nCheck supports pre-waiving.")
public class Check_R_1051
extends OVMComplianceCheck {
    private RfClass uvmComponent;
    private static final Set<String> PRE_POST_PHASE_METHODS = new HashSet<String>();

    static {
        PRE_POST_PHASE_METHODS.add("pre_reset_phase");
        PRE_POST_PHASE_METHODS.add("post_reset_phase");
        PRE_POST_PHASE_METHODS.add("pre_configure_phase");
        PRE_POST_PHASE_METHODS.add("post_configure_phase");
        PRE_POST_PHASE_METHODS.add("pre_main_phase");
        PRE_POST_PHASE_METHODS.add("post_main_phase");
        PRE_POST_PHASE_METHODS.add("pre_shutdown_phase");
        PRE_POST_PHASE_METHODS.add("post_shutdown_phase");
    }

    public Check_R_1051(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uvmComponent = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_component", true);
        if (this.uvmComponent == null) {
            return;
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            this.checkClass((RfClass)clazz);
        }
    }

    private void checkClass(RfClass clazz) {
        if (clazz == null) {
            return;
        }
        this.notifyCheckAlive();
        RfFileDef file = clazz.getFile();
        if (file == null) {
            return;
        }
        if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) {
            return;
        }
        if (!LintUtils.isSubClassOf(clazz, this.uvmComponent)) {
            return;
        }
        this.checkMethods(clazz.getLocalMembers(RfFunction.class), clazz);
    }

    private void checkMethods(Collection<RfFunction> methods, RfClass currentClass) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (RfFunction method : methods) {
            if (method == null || method.isPredefined() || !PRE_POST_PHASE_METHODS.contains(method.getName())) continue;
            this.addHit(method, "Phase method '" + method.getName() + "' is overridden in the '" + currentClass.getName() + "' class!");
        }
    }
}

