/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractMethodsCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1052")
@CheckName(value="R.1052")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.FIELD})
@CheckTitle(value="Getters should refer the expected fields")
@CheckDescription(value="This check flags all getters where the corresponding field is not returned.\nThe name of the corresponding field is determined by removing the <prefix> from the method name.\n\nNot allowed:\nfunction int get_y (); // field 'y' is not used in the return value\n\treturn this.x; // or return x; or get_y = this.x\nendfunction\n\nAllowed:\nfunction int get_y ();\n\treturn this.y; // or return y; or get_y = this.y\nendfunction\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="prefix", defaultValue="get_")
public class Check_R_1052
extends AbstractMethodsCheck {
    private String expectedFieldName;
    private RfFunction currentMethod;

    public Check_R_1052(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkMethod(RfFunction method, ParserPath parserPath) {
        if (method == null || parserPath == null) {
            return;
        }
        this.currentMethod = method;
        String currentMethodName = method.getName();
        this.expectedFieldName = currentMethodName.substring(this.methodPrefix.length());
        method.visitHidObject(null, new LocalHidOperatorVisitor());
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (hidObject.isHidden()) {
                return true;
            }
            if (hidObject.isAssignment()) {
                IHidObject lhValue = hidObject.getLHValue();
                if (lhValue == null || !(lhValue instanceof RfHid)) {
                    return true;
                }
                RfHid lhValueHid = (RfHid)lhValue;
                if (!(lhValueHid.getElement() instanceof RfResultImplicitVariable)) {
                    return true;
                }
                if (!Check_R_1052.this.currentMethod.getName().equals(lhValueHid.getName())) {
                    return true;
                }
                ListContainer rhValues = hidObject.getRHValues();
                if (rhValues == null || rhValues.isEmpty()) {
                    return true;
                }
                IHidObject actualFieldObject = (IHidObject)rhValues.get(0);
                if (actualFieldObject == null) {
                    return true;
                }
                if (!(actualFieldObject instanceof RfHid)) {
                    return true;
                }
                RfHid actualFieldHid = (RfHid)actualFieldObject;
                String actualFieldName = actualFieldHid.getName();
                if (Check_R_1052.this.expectedFieldName.equals(actualFieldName)) {
                    return true;
                }
                Check_R_1052.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Method " + LintUtils.getNamedElementFullName(Check_R_1052.this.currentMethod) + "() accesses field '" + actualFieldName + "' instead of '" + Check_R_1052.this.expectedFieldName + "'!");
                return true;
            }
            if (!hidObject.isReturnStatement()) {
                return true;
            }
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject actualFieldObject = (IHidObject)rhValues.get(0);
            if (actualFieldObject == null) {
                return true;
            }
            if (!(actualFieldObject instanceof RfHid)) {
                return true;
            }
            RfHid actualFieldHid = (RfHid)actualFieldObject;
            String actualFieldName = actualFieldHid.getName();
            if (Check_R_1052.this.expectedFieldName.equals(actualFieldName)) {
                return true;
            }
            Check_R_1052.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Method " + LintUtils.getNamedElementFullName(Check_R_1052.this.currentMethod) + "() accesses field '" + actualFieldName + "' instead of '" + Check_R_1052.this.expectedFieldName + "'!");
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

