/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;

@CheckVersion(value="21.1.38")
@CheckID(value="R.1054")
@CheckName(value="R.1054")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.PACKAGE, RuleLabel.DIRECTIVE})
@CheckTitle(value="Use `include directives within a package to allow each class to be placed in a separate file")
@CheckDescription(value="It is good practice to use `include directives within a package, as opposed to having all the classes in one very large package file.\n\nCheck supports pre-waiving.")
public class Check_R_1054
extends OVMComplianceCheck {
    public Check_R_1054(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            String classPath;
            this.notifyCheckAlive();
            RfNamedElement scope = clazz.getEnclosingScope();
            if (scope == null || !(scope instanceof RfPackage)) continue;
            ParserPath classParserPath = clazz.getDeclaration().getParserPath();
            ParserPath packageParserPath = scope.getDeclaration().getParserPath();
            if (classParserPath == null || packageParserPath == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this) || (classPath = classParserPath.path) == null || !classPath.equals(packageParserPath.path)) continue;
            this.addHit(clazz, "Class " + clazz.getFullName() + " not declared in its own separate file!");
        }
    }
}

