/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.38")
@CheckID(value="R.1055")
@CheckName(value="R.1055")
@CheckLabel(labels={RuleLabel.OBJECTION, RuleLabel.PERFORMANCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Set propagate mode of every objection to 0")
@CheckDescription(value="Every objection should have hierarchical propagation disabled in order to avoid the speed penalty and the functionally redundancy.\nThis can be done by calling the set_propagate_mode(0) method (UVM 1.2 onward) or by setting the m_hier_mode field of every objection to 0.\nExamples:\nclass my_class_uvm_1_2;\n  function foo();\n    uvm_objection bad_obj; // not allowed\n    uvm_objection good_obj; // allowed\n    good_obj.set_propagate_mode(0);\n  endfunction : foo\nendclass : my_class_uvm_1_2\n\nclass my_class_uvm_1_1;\n  function foo();\n    uvm_objection bad_obj; // not allowed\n    uvm_objection good_obj; // allowed\n    good_obj.m_hier_mode = 0;\n  endfunction : foo\nendclass : my_class_uvm_1_1")
public class Check_R_1055
extends OVMComplianceCheck {
    RfClass objectionClass;
    HashSet<RfField> objectionsWithPropagateMode = new HashSet();

    public Check_R_1055(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.objectionClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_objection", true);
        this.objectionsWithPropagateMode.clear();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new CallVisitor());
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new AssignmentOperatorVisitor());
        this.fOVMProject.getRfProject().accept(this.fOVMProject.getRfProject(), new LocalNamedElementVisitor());
    }

    private class AssignmentOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private AssignmentOperatorVisitor() {
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (!hidOperator.isAssignment()) {
                return true;
            }
            Check_R_1055.this.notifyCheckAlive();
            if (!(hidOperator.getLHValue() instanceof RfHid)) {
                return true;
            }
            RfHid lhValue = (RfHid)hidOperator.getLHValue();
            if (!(lhValue.getElement() instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)lhValue.getElement();
            if (field.isPredefined()) {
                return true;
            }
            if (field.getEnclosingScope(RfClass.class) != Check_R_1055.this.objectionClass) {
                return true;
            }
            if (!field.getName().equals("m_hier_mode")) {
                return true;
            }
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            if (!(rhValues.get(0) instanceof RfHidImplicit)) {
                return true;
            }
            if (((RfHidImplicit)rhValues.get(0)).getName().equals("0") && lhValue.getParentHid() != null && lhValue.getParentHid().getElement() != null) {
                Check_R_1055.this.objectionsWithPropagateMode.add((RfField)lhValue.getParentHid().getElement());
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private class CallVisitor
    implements IHidVisitor<RfHid> {
        private CallVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfFunction)) {
                return true;
            }
            Check_R_1055.this.notifyCheckAlive();
            IRfNamedElement element = hidObject.getElement();
            if (!((RfFunction)element).getName().equals("set_propagate_mode")) {
                return true;
            }
            List argumentValues = ((IHidAccessArgs)hidObject.getFirstAccess()).getArgumentValues();
            if (argumentValues == null || argumentValues.size() != 1) {
                return true;
            }
            RfHidOperator args = (RfHidOperator)argumentValues.get(0);
            ListContainer rhValues = args.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            if (!(rhValues.get(0) instanceof RfHidImplicit)) {
                return true;
            }
            if (((RfHidImplicit)rhValues.get(0)).getName().equals("0") && hidObject.getParentHid() != null && hidObject.getParentHid().getElement() instanceof RfField) {
                Check_R_1055.this.objectionsWithPropagateMode.add((RfField)hidObject.getParentHid().getElement());
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    private class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        private LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement element) {
            if (!(element instanceof RfField)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfField field = (RfField)element;
            Check_R_1055.this.notifyCheckAlive();
            RfClass classs = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (classs == null) {
                return true;
            }
            if (!LintUtils.isChildOf(classs, Check_R_1055.this.objectionClass) && classs != Check_R_1055.this.objectionClass) {
                return true;
            }
            if (!Check_R_1055.this.objectionsWithPropagateMode.contains(field)) {
                Check_R_1055.this.addHit(field, "Objection '" + field.getName() + "' should set propagate mode to 0!");
            }
            return true;
        }
    }
}

