/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractLiteralComparison;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.42")
@CheckID(value="R.1056")
@CheckName(value="R.1056")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not compare incompatible types")
@CheckDescription(value="This rule flags comparisons made between incompatible types\nExample:\nassert (primitive_var == null); // not allowed\nassert (object == null); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1056
extends AbstractLiteralComparison {
    @CheckParameter(defaultValue="false", description="When true, packed dimensions are ignored for the comparisson", name="ignorePackedDimensions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnorePackedDimensions;
    private static final Set<AbstractLiteralComparison.Type> NULL_INCOMPATIBLE_TYPES = Stream.of(AbstractLiteralComparison.Type.PRIMITIVE, AbstractLiteralComparison.Type.PRIMITIVE_LIST, AbstractLiteralComparison.Type.LIST).collect(Collectors.toCollection(HashSet::new));
    private static final Set<AbstractLiteralComparison.Type> LIST_TYPES = Stream.of(AbstractLiteralComparison.Type.PRIMITIVE_LIST, AbstractLiteralComparison.Type.LIST).collect(Collectors.toCollection(HashSet::new));

    public Check_R_1056(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected DVTPair<AbstractLiteralComparison.Type, Object> findObjectType(IHid hidObject) {
        if (hidObject instanceof RfHidImplicit && ((RfHidImplicit)hidObject).isLiteralNull()) {
            return new DVTPair((Object)AbstractLiteralComparison.Type.LITERAL_NULL, null);
        }
        if (hidObject instanceof RfHidImplicit && !hidObject.getName().equals("default")) {
            return new DVTPair((Object)AbstractLiteralComparison.Type.PRIMITIVE, null);
        }
        IRfNamedElement assocType = null;
        if (hidObject instanceof RfHid) {
            IRfNamedElement element = ((RfHid)hidObject).getElement();
            if (element instanceof RfField && ((RfField)element).isEnumElement() && ((RfField)element).getEnclosingScope() instanceof RfStruct) {
                return new DVTPair((Object)AbstractLiteralComparison.Type.ENUM_ELEMENT, (Object)((RfField)element).getEnclosingScope());
            }
            if (element instanceof RfField && ((RfField)element).isParameterNoDataType()) {
                return new DVTPair((Object)AbstractLiteralComparison.Type.UNDETERMINED, null);
            }
            if (!(element instanceof RfAssociatedType)) {
                return new DVTPair((Object)AbstractLiteralComparison.Type.UNDETERMINED, null);
            }
            assocType = ((RfAssociatedType)element).getAssociatedType();
        } else if (hidObject instanceof RfHidAccess) {
            assocType = ((RfHidAccess)hidObject).getAssociatedType();
        } else if (hidObject instanceof RfHidOperator) {
            assocType = this.getOperatorType((RfHidOperator)hidObject);
        }
        while (assocType instanceof RfTypeAlias) {
            assocType = ((RfTypeAlias)assocType).getAssociatedType();
        }
        if (assocType instanceof RfBitVectorScalarType) {
            return new DVTPair((Object)AbstractLiteralComparison.Type.PRIMITIVE, (Object)assocType);
        }
        if (assocType instanceof IRfListType) {
            if (this.pIgnorePackedDimensions && assocType instanceof RfListType && ((RfListType)assocType).getPackedDimension() != null && !((RfListType)assocType).getPackedDimension().isEmpty() && (((RfListType)assocType).getUnpackedDimension() == null || ((RfListType)assocType).getUnpackedDimension().isEmpty())) {
                if ((assocType = ((IRfListType)assocType).getAssociatedType()) instanceof RfBitVectorScalarType) {
                    return new DVTPair((Object)AbstractLiteralComparison.Type.PRIMITIVE, (Object)assocType);
                }
                return new DVTPair((Object)AbstractLiteralComparison.Type.OBJECT, (Object)assocType);
            }
            if (((IRfListType)assocType).getAssociatedType() instanceof RfBitVectorScalarType) {
                return new DVTPair((Object)AbstractLiteralComparison.Type.PRIMITIVE_LIST, (Object)assocType);
            }
            return new DVTPair((Object)AbstractLiteralComparison.Type.LIST, (Object)assocType);
        }
        return new DVTPair((Object)AbstractLiteralComparison.Type.OBJECT, (Object)assocType);
    }

    protected DVTPair<AbstractLiteralComparison.Type, Object> findObjectType(HidOperator operator) {
        IRfNamedElement assocType = this.getOperatorType(operator);
        while (assocType instanceof RfTypeAlias) {
            assocType = ((RfTypeAlias)assocType).getAssociatedType();
        }
        if (assocType instanceof RfBitVectorScalarType) {
            return new DVTPair((Object)AbstractLiteralComparison.Type.PRIMITIVE, (Object)assocType);
        }
        if (assocType instanceof IRfListType) {
            if (this.pIgnorePackedDimensions && assocType instanceof RfListType && ((RfListType)assocType).getPackedDimension() != null && !((RfListType)assocType).getPackedDimension().isEmpty() && (((RfListType)assocType).getUnpackedDimension() == null || ((RfListType)assocType).getUnpackedDimension().isEmpty())) {
                if ((assocType = ((IRfListType)assocType).getAssociatedType()) instanceof RfBitVectorScalarType) {
                    return new DVTPair((Object)AbstractLiteralComparison.Type.PRIMITIVE, (Object)assocType);
                }
                return new DVTPair((Object)AbstractLiteralComparison.Type.OBJECT, (Object)assocType);
            }
            if (((IRfListType)assocType).getAssociatedType() instanceof RfBitVectorScalarType) {
                return new DVTPair((Object)AbstractLiteralComparison.Type.PRIMITIVE_LIST, (Object)assocType);
            }
            return new DVTPair((Object)AbstractLiteralComparison.Type.LIST, (Object)assocType);
        }
        return new DVTPair((Object)AbstractLiteralComparison.Type.OBJECT, (Object)assocType);
    }

    private IRfNamedElement getOperatorType(HidOperator operator) {
        ISDataAbstract resolvedType = operator.getOperatorResolvedType();
        if (resolvedType == null) {
            return null;
        }
        ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
        if (dataType == null) {
            return null;
        }
        return SDataUtils.getUndefinedDataType((ISDataAbstract)dataType) == null ? dataType.getType() : null;
    }

    @Override
    protected void checkComparison(ParserPath path, HidOperator hidOperator, IHid lhValue, DVTPair<AbstractLiteralComparison.Type, Object> lhPair, IHid rhValue, DVTPair<AbstractLiteralComparison.Type, Object> rhPair) {
        if (lhValue == null || rhValue == null) {
            return;
        }
        AbstractLiteralComparison.Type lhType = (AbstractLiteralComparison.Type)((Object)lhPair.getKey());
        AbstractLiteralComparison.Type rhType = (AbstractLiteralComparison.Type)((Object)rhPair.getKey());
        IRfNamedElement lhAssocType = (IRfNamedElement)lhPair.getValue();
        IRfNamedElement rhAssocType = (IRfNamedElement)rhPair.getValue();
        if (lhType == AbstractLiteralComparison.Type.LITERAL_NULL && NULL_INCOMPATIBLE_TYPES.contains((Object)rhType) || rhType == AbstractLiteralComparison.Type.LITERAL_NULL && NULL_INCOMPATIBLE_TYPES.contains((Object)lhType)) {
            this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison between incompatible types: \"" + HidUtils.toNiceString((IHidObject)hidOperator) + "\"!");
            return;
        }
        if (lhType == AbstractLiteralComparison.Type.LITERAL_NULL || rhType == AbstractLiteralComparison.Type.LITERAL_NULL) {
            return;
        }
        if (LIST_TYPES.contains((Object)lhType) && LIST_TYPES.contains((Object)rhType)) {
            lhAssocType = ((IRfListType)lhAssocType).getAssociatedType();
            rhAssocType = ((IRfListType)rhAssocType).getAssociatedType();
            lhType = lhAssocType instanceof RfBitVectorScalarType ? AbstractLiteralComparison.Type.PRIMITIVE : AbstractLiteralComparison.Type.OBJECT;
            rhType = rhAssocType instanceof RfBitVectorScalarType ? AbstractLiteralComparison.Type.PRIMITIVE : AbstractLiteralComparison.Type.OBJECT;
        }
        if (lhAssocType == null || rhAssocType == null) {
            return;
        }
        if (lhType == AbstractLiteralComparison.Type.PRIMITIVE && rhType == AbstractLiteralComparison.Type.PRIMITIVE) {
            return;
        }
        if (lhType == AbstractLiteralComparison.Type.OBJECT && lhAssocType instanceof RfClass && rhType == AbstractLiteralComparison.Type.OBJECT && rhAssocType instanceof RfClass) {
            RfClass lhClass = (RfClass)lhAssocType;
            RfClass rhClass = (RfClass)rhAssocType;
            if (lhClass.getExtendedType() != null || lhClass.getImplementedTypes() != null || rhClass.getExtendedType() != null || rhClass.getImplementedTypes() != null) {
                return;
            }
        }
        if (lhAssocType instanceof RfStruct && ((RfStruct)lhAssocType).isPacked() || rhAssocType instanceof RfStruct && ((RfStruct)rhAssocType).isPacked()) {
            return;
        }
        if (!lhAssocType.equals(rhAssocType)) {
            this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison between incompatible types: " + HidUtils.toNiceString((IHidObject)hidOperator) + "!");
        }
    }
}

