/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractMethodsCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1057")
@CheckName(value="R.1057")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.FIELD})
@CheckTitle(value="Setters should refer the expected fields")
@CheckDescription(value="This check flags all setters where the corresponding field is not referred.\nThe name of the corresponding field is determined by removing the <prefix> from the method name.\n\nNot allowed:\nfunction void set_x (int val); // field 'x' is not updated\n\tthis.y = val;\nendfunction\n\nAllowed:\nfunction void set_x (int val);\n\tthis.x = val;\nendfunction\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="prefix", defaultValue="set_")
public class Check_R_1057
extends AbstractMethodsCheck {
    private String expectedFieldName;
    private boolean fieldIsAccessed;

    public Check_R_1057(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkMethod(RfFunction method, ParserPath parserPath) {
        if (method == null || parserPath == null) {
            return;
        }
        String currentMethodName = method.getName();
        this.expectedFieldName = currentMethodName.substring(this.methodPrefix.length());
        this.fieldIsAccessed = false;
        method.visitHidObject(null, new LocalHidOperatorVisitor());
        if (!this.fieldIsAccessed) {
            this.addHit(method, "Field '" + this.expectedFieldName + "' is never accessed inside " + LintUtils.getNamedElementFullName(method) + "!");
        }
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (hidObject.isHidden()) {
                return true;
            }
            if (!hidObject.isAssignment()) {
                return true;
            }
            IHidObject actualFieldObject = hidObject.getLHValue();
            if (actualFieldObject == null) {
                return true;
            }
            if (!(actualFieldObject instanceof RfHid)) {
                return true;
            }
            RfHid actualFieldHid = (RfHid)actualFieldObject;
            String actualFieldName = actualFieldHid.getName();
            if (!Check_R_1057.this.expectedFieldName.equals(actualFieldName)) {
                return true;
            }
            Check_R_1057.this.fieldIsAccessed = true;
            return false;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

