/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMacroUseCheck;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="21.1.38")
@CheckID(value="R.1060")
@CheckName(value="R.1060")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.OVERRIDE, RuleLabel.MACRO, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Use recording macros when overriding do_record")
@CheckDescription(value="When overriding do_record method in sequence items, use recording macros to simplify the code.\n\nCheck supports pre-waiving.")
public class Check_R_1060
extends AbstractMacroUseCheck {
    public Check_R_1060(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_RECORD_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_RECORD_MACROS));
        aRfProject.lintTrackMacrosByNames("function", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        String[] libRecordMacros = isOVMLib ? XVMMacros.OVM_RECORD_MACROS : XVMMacros.UVM_RECORD_MACROS;
        String macroNameInHitMessage = isOVMLib ? "`ovm_record_*" : "`uvm_record_*";
        this.checkMacrosInClassesAndFunction(this.fOVMProject.fSequenceItems.values(), "do_record", new HashSet<String>(Arrays.asList(libRecordMacros)), macroNameInHitMessage);
    }
}

