/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.48")
@CheckID(value="R.1061")
@CheckName(value="R.1061")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.OBJECTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not raise or drop objections outside the pre_start / post_start methods of a sequence")
@CheckDescription(value="The body method of the sequence should only execute the raw functional behavior of the sequence.\nThe pre_start and post_start methods are referred to as user-definable callbacks in the UVM class reference.\nWhere a sequence is to raise and drop objections, it should call raise_objection in its pre_start method and drop_objection in its post_start method.\n\nExamples:\n\nvirtual task pre_start();\n\tstarting_phase.raise_objection(starting_phase, \"type_name\", 0); // allowed\nendtask : pre_start\n\nvirtual task body();\n\tstarting_phase.raise_objection(starting_phase, \"type_name\", 0); // not allowed\n\tstarting_phase.drop_objection(starting_phase, \"type_name\", 0); // not allowed\nendtask : body\n\nvirtual task post_start();\n\tstarting_phase.drop_objection(starting_phase, \"type_name\", 0); // allowed\nendtask \n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1061
extends OVMComplianceCheck {
    private static final String PRE_START = "pre_start";
    private static final String POST_START = "post_start";
    private static final String RAISE_OBJECTION = "raise_objection";
    private static final String DROP_OBJECTION = "drop_objection";
    @CheckParameter(defaultValue="false", description="When true, the raise_objection and drop_objection calls are allowed in a function called from the pre_start respectively post_start methods.", name="allowIndirectCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowIndirectCallsValue;
    LinkedHashMap<RfFunction, List<RfHid>> preStartHits = new LinkedHashMap();
    LinkedHashMap<RfFunction, List<RfHid>> postStartHits = new LinkedHashMap();

    public Check_R_1061(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass xvmSequence = this.fOVMProject.getLibraryKind() == 2 ? this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_sequence", true) : this.fOVMProject.getRfProject().getClass("ovm_pkg::ovm_sequence", true);
        if (xvmSequence == null) {
            return;
        }
        Set<RfClass> allSequences = this.fOVMProject.getAllXVMSubClasses(xvmSequence);
        if (allSequences.isEmpty()) {
            return;
        }
        for (RfClass clazz : allSequences) {
            List hids;
            ParserPath classParserPath;
            RfFileDef classFile = clazz.getFile();
            if (classFile == null || (classParserPath = classFile.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.notifyCheckAlive();
            List<RfClass> parentList = this.getClassHierarchy(clazz);
            RfFunction preStart = clazz.getTaskWithPrefix(PRE_START, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            RfFunction postStart = clazz.getTaskWithPrefix(POST_START, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            List<RfFunction> functions = clazz.getLocalMembers(RfFunction.class);
            if (functions == null || functions.isEmpty()) continue;
            for (RfFunction rfFunction : functions) {
                if (this.fOVMProject.isOVMElement(rfFunction) || rfFunction.isPredefined()) continue;
                this.notifyCheckAlive();
                rfFunction.visitHidObject(this.fOVMProject.getRfProject(), new ObjectionCallTreeVisitor(parentList, rfFunction, preStart, postStart));
            }
            if (this.pAllowIndirectCallsValue) {
                if (preStart != null) {
                    preStart.visitHidObject(this.fOVMProject.getRfProject(), new MethodCallTreeVisitor(parentList, PRE_START, new ArrayList<RfFunction>()));
                }
                if (postStart != null) {
                    postStart.visitHidObject(this.fOVMProject.getRfProject(), new MethodCallTreeVisitor(parentList, POST_START, new ArrayList<RfFunction>()));
                }
            }
            for (Map.Entry entry : this.preStartHits.entrySet()) {
                hids = (List)entry.getValue();
                for (RfHid hid : hids) {
                    this.addHit(classParserPath, hid, "Function " + HidUtils.toNiceString((IHidObject)hid) + " called outside pre_start() method!");
                }
            }
            for (Map.Entry entry : this.postStartHits.entrySet()) {
                hids = (List)entry.getValue();
                for (RfHid hid : hids) {
                    this.addHit(classParserPath, hid, "Function " + HidUtils.toNiceString((IHidObject)hid) + " called outside post_start() method!");
                }
            }
            this.preStartHits.clear();
            this.postStartHits.clear();
        }
    }

    private List<RfClass> getClassHierarchy(RfClass clazz) {
        ArrayList<RfClass> result = new ArrayList<RfClass>();
        result.add(clazz);
        RfClass parentClass = clazz.getParent();
        while (parentClass != null && !this.fOVMProject.isOVMElement(parentClass)) {
            result.add(parentClass);
            parentClass = parentClass.getParent();
        }
        return result;
    }

    private RfFunction findMethodImplementation(List<RfClass> parentList, RfFunction localFunction) {
        if (parentList == null || parentList.isEmpty()) {
            return null;
        }
        for (RfClass parent : parentList) {
            RfFunction childCall = null;
            if (localFunction.isFunction()) {
                childCall = parent.getFunctionWithPrefix(localFunction.getName(), 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            } else if (localFunction.isTask()) {
                childCall = parent.getTaskWithPrefix(localFunction.getName(), 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (childCall == null) continue;
            return childCall;
        }
        return null;
    }

    private boolean isSuper(RfHid hid) {
        HidAccess hidAccess = hid.getParentAccess();
        if (hidAccess == null) {
            return false;
        }
        Hid parentHid = hidAccess.getParentHid();
        if (parentHid == null) {
            return false;
        }
        return parentHid.getName().startsWith("super");
    }

    private class MethodCallTreeVisitor
    extends RfHidVisitor {
        private List<RfClass> parentList;
        private String checkedMethod;
        private List<RfFunction> visitedFunction;

        public MethodCallTreeVisitor(List<RfClass> parentList, String methodType, List<RfFunction> visitedFunction) {
            this.parentList = parentList;
            this.checkedMethod = methodType;
            this.visitedFunction = visitedFunction;
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction localFunction = (RfFunction)hidNamedElement;
            if (localFunction.isPredefined()) {
                return true;
            }
            if (Check_R_1061.this.fOVMProject.isOVMElement(localFunction)) {
                return true;
            }
            Check_R_1061.this.notifyCheckAlive();
            RfFunction tmpFunc = null;
            tmpFunc = Check_R_1061.this.isSuper(hid) && !this.parentList.isEmpty() ? Check_R_1061.this.findMethodImplementation(this.parentList.subList(1, this.parentList.size()), localFunction) : Check_R_1061.this.findMethodImplementation(this.parentList, localFunction);
            if (tmpFunc != null) {
                localFunction = tmpFunc;
            }
            if (this.visitedFunction.contains(localFunction)) {
                return true;
            }
            if (Check_R_1061.PRE_START.equals(this.checkedMethod) && Check_R_1061.this.preStartHits.containsKey(localFunction)) {
                Check_R_1061.this.preStartHits.remove(localFunction);
            }
            if (Check_R_1061.POST_START.equals(this.checkedMethod) && Check_R_1061.this.postStartHits.containsKey(localFunction)) {
                Check_R_1061.this.postStartHits.remove(localFunction);
            }
            this.visitedFunction.add(localFunction);
            localFunction.visitHidObject(Check_R_1061.this.fOVMProject.getRfProject(), new MethodCallTreeVisitor(this.parentList, this.checkedMethod, this.visitedFunction));
            this.visitedFunction.remove(localFunction);
            return true;
        }
    }

    private class ObjectionCallTreeVisitor
    extends RfHidVisitor {
        private List<RfClass> classParentList;
        private RfFunction function;
        private RfFunction preStart;
        private RfFunction postStart;

        public ObjectionCallTreeVisitor(List<RfClass> parentList, RfFunction function, RfFunction preStart, RfFunction postStart) {
            this.classParentList = parentList;
            this.function = function;
            this.preStart = preStart;
            this.postStart = postStart;
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction localFunctionCall = (RfFunction)hidNamedElement;
            String functionName = localFunctionCall.getName();
            if (functionName == null) {
                return true;
            }
            if (Check_R_1061.this.fOVMProject.isOVMElement(localFunctionCall) && !Check_R_1061.RAISE_OBJECTION.equals(functionName) && !Check_R_1061.DROP_OBJECTION.equals(functionName)) {
                return true;
            }
            RfFunction tmpFunc = null;
            tmpFunc = Check_R_1061.this.isSuper(hid) && !this.classParentList.isEmpty() ? Check_R_1061.this.findMethodImplementation(this.classParentList.subList(1, this.classParentList.size()), localFunctionCall) : Check_R_1061.this.findMethodImplementation(this.classParentList, localFunctionCall);
            if (tmpFunc != null) {
                localFunctionCall = tmpFunc;
            }
            Check_R_1061.this.notifyCheckAlive();
            if (!this.function.equals(this.preStart) && Check_R_1061.RAISE_OBJECTION.equals(functionName)) {
                this.addHidToMap(hid, Check_R_1061.this.preStartHits);
            } else if (!this.function.equals(this.postStart) && Check_R_1061.DROP_OBJECTION.equals(functionName)) {
                this.addHidToMap(hid, Check_R_1061.this.postStartHits);
            }
            return true;
        }

        private void addHidToMap(RfHid hid, LinkedHashMap<RfFunction, List<RfHid>> postStartHits) {
            List<RfHid> hidsList = postStartHits.get(this.function);
            if (hidsList == null) {
                hidsList = new ArrayList<RfHid>();
            }
            hidsList.add(hid);
            postStartHits.put(this.function, hidsList);
        }
    }
}

