/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.MultiLineClockStatus;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1064")
@CheckName(value="R.1064")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.CLOCK, RuleLabel.DESIGN})
@CheckTitle(value="Do not use locally generated clock signals")
@CheckDescription(value="This rule flags all locally generated clock signals.\n\nA clock signal is flagged if inside an always/forever block the value of the signal changes between 0 and 1 with the same frequency\nThe variable used for the signal must be of type bit, logic or reg.\n\nExample:\nbit clk1, clk2;\n`define frequency 10\n\nalways begin // single line clock\n\t#((`frequency)/2) clk1 = !clk1;\nend\n\nalways begin // multiple line clock\n\tclk2 = 0;\n\t#((`frequency)/2);\n\tclk2 = 1\n\t#((`frequency)/2);\nend\n\nCheck supports pre-waiving.")
public class Check_R_1064
extends OVMComplianceCheck {
    private static String SINGLE_LINE_ERROR_MESSAGE = "Clock signal {0} found(generated in assignment found at {1})!";
    private static String MULTI_LINE_ERROR_MESSAGE = "Clock signal {0} found(generated in block found at {1})!";
    private HashMap<RfField, Integer> fieldAssignmentCount = new HashMap();
    private HashMap<RfField, MultiLineClockStatus> fieldStatus = new HashMap();
    private LinkedHashMap<RfHidOperator, SignalOperatorType> operators = new LinkedHashMap();
    private Set<RfField> invalidCandidates = new HashSet<RfField>();
    private HidOperator prevDelay;
    private int delayCounter;
    private boolean searchMultiLineClocks;

    public Check_R_1064(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        List<RfActionBlock> rfActionBlocks = rfProject.getAllActionBlocks();
        if (rfActionBlocks == null) {
            return;
        }
        for (RfActionBlock rfActionBlock : rfActionBlocks) {
            RfHidHolder rfHidHolder;
            RfFileDef file;
            this.notifyCheckAlive();
            if (!rfActionBlock.isAlways() && !rfActionBlock.isForever() || (file = rfActionBlock.getFile()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this) || (rfHidHolder = rfActionBlock.getHidHolder()) == null) continue;
            this.fieldAssignmentCount.clear();
            this.fieldStatus.clear();
            this.operators.clear();
            this.delayCounter = 0;
            this.searchMultiLineClocks = false;
            this.invalidCandidates.clear();
            rfActionBlock.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator hidOperator) {
                    if (!(hidOperator instanceof RfHidOperator)) {
                        return true;
                    }
                    RfHidOperator rfHidOperator = (RfHidOperator)hidOperator;
                    if (Check_R_1064.this.checkDelay(rfHidOperator)) {
                        Check_R_1064.this.operators.put(rfHidOperator, SignalOperatorType.DELAY);
                        ++Check_R_1064.this.delayCounter;
                        if (Check_R_1064.this.delayCounter == 1) {
                            Check_R_1064.this.prevDelay = rfHidOperator;
                            Check_R_1064.this.searchMultiLineClocks = false;
                        } else {
                            Check_R_1064.this.searchMultiLineClocks = Check_R_1064.this.delayCounter == 2 ? (Check_R_1064.this.prevDelay.getOperatorType() == rfHidOperator.getOperatorType() ? Check_R_1064.this.prevDelay.getLHValue().equals(rfHidOperator.getLHValue()) : false) : false;
                        }
                    } else if (rfHidOperator.isAssignment()) {
                        IHidObject rhObject;
                        IHidObject lhObject = rfHidOperator.getLHValue();
                        if (!(lhObject instanceof RfHid)) {
                            return true;
                        }
                        RfHid lhHid = (RfHid)lhObject;
                        IRfNamedElement iRfNamedElement = lhHid.getElement();
                        if (!(iRfNamedElement instanceof RfField)) {
                            return true;
                        }
                        RfField rfField = (RfField)iRfNamedElement;
                        RfNamedElement rfFieldType = LintUtils.getAssociatedFinalType(rfField);
                        if (rfFieldType == null) {
                            return true;
                        }
                        String hidType = rfFieldType.getName();
                        if (!("bit".equals(hidType) || "logic".equals(hidType) || "reg".equals(hidType))) {
                            return true;
                        }
                        if (Check_R_1064.this.invalidCandidates.contains(rfField)) {
                            return true;
                        }
                        int value = Check_R_1064.this.fieldAssignmentCount.containsKey(rfField) ? Check_R_1064.this.fieldAssignmentCount.get(rfField) : 0;
                        Check_R_1064.this.fieldAssignmentCount.put(rfField, ++value);
                        if (value > 2) {
                            Check_R_1064.this.invalidCandidates.add(rfField);
                            return true;
                        }
                        if (!Check_R_1064.this.fieldStatus.containsKey(rfField)) {
                            Check_R_1064.this.fieldStatus.put(rfField, new MultiLineClockStatus());
                        }
                        if ((rhObject = (IHidObject)rfHidOperator.getRHValues().get(0)) instanceof RfHidImplicit) {
                            RfHidImplicit rhHidImplicit = (RfHidImplicit)rhObject;
                            Number number = rhHidImplicit.parseNumberValue();
                            if (number == null) {
                                Check_R_1064.this.invalidCandidates.add(rfField);
                                return true;
                            }
                            int assignedValue = number.intValue();
                            if (assignedValue == 0) {
                                Check_R_1064.this.operators.put(rfHidOperator, SignalOperatorType.ZERO_ASSIGNMENT);
                            } else if (assignedValue == 1) {
                                Check_R_1064.this.operators.put(rfHidOperator, SignalOperatorType.ONE_ASSIGNMENT);
                            } else {
                                Check_R_1064.this.invalidCandidates.add(rfField);
                            }
                        } else if (rhObject instanceof RfHidOperator) {
                            RfHidOperator rhOperator = (RfHidOperator)rhObject;
                            if (!Check_R_1064.this.checkNegation(rhOperator)) {
                                Check_R_1064.this.invalidCandidates.add(rfField);
                                return true;
                            }
                            IHidObject iHidObject = rhOperator.getLHValue();
                            if (!(iHidObject instanceof RfHid)) {
                                Check_R_1064.this.invalidCandidates.add(rfField);
                                return true;
                            }
                            RfHid rhHid = (RfHid)iHidObject;
                            if (!iRfNamedElement.equals(rhHid.getElement())) {
                                Check_R_1064.this.invalidCandidates.add(rfField);
                                return true;
                            }
                            Check_R_1064.this.operators.put(rfHidOperator, SignalOperatorType.NON_ASSIGNMENT);
                        } else {
                            Check_R_1064.this.invalidCandidates.add(rfField);
                        }
                    }
                    return true;
                }
            });
            if (this.delayCounter < 1) continue;
            for (Map.Entry<RfHidOperator, SignalOperatorType> entry : this.operators.entrySet()) {
                String errorMessage;
                MultiLineClockStatus currentStatus;
                RfField rfField;
                RfHid lhHid;
                IRfNamedElement iRfNamedElement;
                IHidObject lhObject;
                String errorMessage2;
                RfHidOperator operator = entry.getKey();
                SignalOperatorType signalOperatorType = entry.getValue();
                if (signalOperatorType.equals((Object)SignalOperatorType.DELAY)) {
                    if (!this.searchMultiLineClocks) continue;
                    Iterator<Map.Entry<RfField, MultiLineClockStatus>> iterator = this.fieldStatus.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<RfField, MultiLineClockStatus> fieldEntry = iterator.next();
                        RfField currentField = fieldEntry.getKey();
                        MultiLineClockStatus currentStatus2 = fieldEntry.getValue();
                        if (this.invalidCandidates.contains(currentField)) {
                            iterator.remove();
                            continue;
                        }
                        if (!currentStatus2.isPreviouslyDelayed()) {
                            if (currentStatus2.isFirstDelayed()) {
                                currentStatus2.setSecondDelay(true);
                                currentStatus2.setPrevDelay(true);
                                if (currentStatus2.checkStatusComplete()) {
                                    errorMessage2 = MessageFormat.format(MULTI_LINE_ERROR_MESSAGE, LintUtils.getNamedElementFullName(currentField), this.link("line " + Integer.toString(rfActionBlock.getLine()), rfActionBlock.getFile().getParserPath().path, rfActionBlock.getLine()));
                                    this.addHit(currentField, errorMessage2);
                                    iterator.remove();
                                    continue;
                                }
                            } else {
                                currentStatus2.setFirstDelay(true);
                                currentStatus2.setPrevDelay(true);
                            }
                            this.fieldStatus.put(currentField, currentStatus2);
                            continue;
                        }
                        iterator.remove();
                    }
                    continue;
                }
                if (signalOperatorType.equals((Object)SignalOperatorType.ZERO_ASSIGNMENT)) {
                    if (!this.searchMultiLineClocks || !((lhObject = operator.getLHValue()) instanceof RfHid) || !((iRfNamedElement = (lhHid = (RfHid)lhObject).getElement()) instanceof RfField) || this.invalidCandidates.contains(rfField = (RfField)iRfNamedElement)) continue;
                    if (this.fieldAssignmentCount.get(rfField) != 2) {
                        this.invalidCandidates.add(rfField);
                        continue;
                    }
                    currentStatus = this.fieldStatus.get(rfField);
                    if (currentStatus == null) continue;
                    if (currentStatus.checkStatusNoProgress()) {
                        currentStatus.setZeroAssignment(true);
                        continue;
                    }
                    if (currentStatus.isPreviouslyDelayed() && !currentStatus.isZeroAssigned()) {
                        currentStatus.setZeroAssignment(true);
                        currentStatus.setPrevDelay(false);
                        if (!currentStatus.checkStatusComplete()) continue;
                        errorMessage = MessageFormat.format(MULTI_LINE_ERROR_MESSAGE, LintUtils.getNamedElementFullName(rfField), this.link("line " + Integer.toString(rfActionBlock.getLine()), rfActionBlock.getFile().getParserPath().path, rfActionBlock.getLine()));
                        this.addHit(rfField, errorMessage);
                        this.fieldStatus.remove(rfField);
                        continue;
                    }
                    this.invalidCandidates.add(rfField);
                    this.fieldStatus.remove(rfField);
                    continue;
                }
                if (signalOperatorType.equals((Object)SignalOperatorType.ONE_ASSIGNMENT)) {
                    if (!this.searchMultiLineClocks || !((lhObject = operator.getLHValue()) instanceof RfHid) || !((iRfNamedElement = (lhHid = (RfHid)lhObject).getElement()) instanceof RfField) || this.invalidCandidates.contains(rfField = (RfField)iRfNamedElement)) continue;
                    if (this.fieldAssignmentCount.get(rfField) != 2) {
                        this.invalidCandidates.add(rfField);
                        continue;
                    }
                    currentStatus = this.fieldStatus.get(rfField);
                    if (currentStatus == null) continue;
                    if (currentStatus.checkStatusNoProgress()) {
                        currentStatus.setOneAssignment(true);
                        continue;
                    }
                    if (currentStatus.isPreviouslyDelayed() && !currentStatus.isOneAssigned()) {
                        currentStatus.setOneAssignment(true);
                        currentStatus.setPrevDelay(false);
                        if (!currentStatus.checkStatusComplete()) continue;
                        errorMessage = MessageFormat.format(MULTI_LINE_ERROR_MESSAGE, LintUtils.getNamedElementFullName(rfField), this.link("line " + Integer.toString(rfActionBlock.getLine()), rfActionBlock.getFile().getParserPath().path, rfActionBlock.getLine()));
                        this.addHit(rfField, errorMessage);
                        this.fieldStatus.remove(rfField);
                        continue;
                    }
                    this.invalidCandidates.add(rfField);
                    this.fieldStatus.remove(rfField);
                    continue;
                }
                if (!signalOperatorType.equals((Object)SignalOperatorType.NON_ASSIGNMENT) || !((lhObject = operator.getLHValue()) instanceof RfHid) || !((iRfNamedElement = (lhHid = (RfHid)lhObject).getElement()) instanceof RfField) || this.invalidCandidates.contains(rfField = (RfField)iRfNamedElement)) continue;
                if (this.fieldAssignmentCount.get(rfField) != 1) {
                    this.invalidCandidates.add(rfField);
                    continue;
                }
                errorMessage2 = MessageFormat.format(SINGLE_LINE_ERROR_MESSAGE, LintUtils.getNamedElementFullName(rfField), this.link("line " + operator.getOccurrence().getLine(), rfActionBlock.getFile().getParserPath().path, operator.getOccurrence().getLine()));
                this.addHit(rfField, errorMessage2);
            }
        }
    }

    private boolean checkDelay(RfHidOperator operator) {
        return operator.isPound() || operator.isPoundPound();
    }

    private boolean checkNegation(RfHidOperator operator) {
        return operator.isLogicalNot() || operator.isBitwiseNot();
    }

    public static enum SignalOperatorType {
        DELAY,
        ZERO_ASSIGNMENT,
        ONE_ASSIGNMENT,
        NON_ASSIGNMENT;

    }
}

