/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.40")
@CheckID(value="R.1065")
@CheckName(value="R.1065")
@CheckLabel(labels={RuleLabel.DRIVER, RuleLabel.METHOD, RuleLabel.SEQUENCER, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not call get or get_next_item methods from drivers")
@CheckDescription(value="A driver should pull transactions from a sequencer using the non-blocking try_* methods in order to maximize reusability in the scenario where the author cannot know whether the sequence will block the execution of the driver.\nIf a sequence, running on a sequencer, does block the flow of transactions to its driver (because the sequence is waiting for some specific event elsewhere in the environment, for example), then calling the blocking get/get_next_item from the driver might cause the driver to miss critical signals on the interface.\n\nCheck supports pre-waiving.")
public class Check_R_1065
extends OVMComplianceCheck {
    private static final String BASE_CLASS_NAME = "uvm_pkg::uvm_driver";

    public Check_R_1065(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(BASE_CLASS_NAME, true);
        if (baseClass == null) {
            return;
        }
        LocalHidVisitor hidVisitor = new LocalHidVisitor();
        Set<RfClass> allDrivers = this.fOVMProject.getAllXVMSubClasses(baseClass);
        if (allDrivers.isEmpty()) {
            return;
        }
        for (RfClass rfClass : allDrivers) {
            rfClass.visitHidObject(this.fOVMProject.getRfProject(), hidVisitor);
        }
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        private static final String CALLER_CLASS_NAME = "uvm_pkg::uvm_seq_item_pull_port";

        LocalHidVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            RfClass namedClass;
            Check_R_1065.this.notifyCheckAlive();
            if (rfHid == null) {
                return true;
            }
            if (Check_R_1065.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (!rfHid.getName().equals("get") && !rfHid.getName().equals("get_next_item")) {
                return true;
            }
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfNamedElement)) {
                return true;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            if ((namedElement = namedElement.getEnclosingScope()) == null || !(namedElement instanceof RfClass)) {
                return true;
            }
            RfClass rfClass = namedClass = namedElement instanceof RfSpecializedClass ? ((RfSpecializedClass)namedElement).getGenericClass() : (RfClass)namedElement;
            if (namedClass == null) {
                return true;
            }
            RfClass callerClass = Check_R_1065.this.fOVMProject.getRfProject().getClass(CALLER_CLASS_NAME, true);
            if (callerClass == null) {
                return true;
            }
            if (!callerClass.equals(namedClass)) {
                return true;
            }
            Check_R_1065.this.addHit(this.parserPath, rfHid, "Function '" + element.getName() + "()' called from driver!");
            return true;
        }
    }
}

