/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="21.1.42")
@CheckID(value="R.1066")
@CheckName(value="R.1066")
@CheckLabel(labels={RuleLabel.PREDEFINED_METHOD, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Check for plusarg aliasing")
@CheckDescription(value="If the prefix of one of the supplied command line arguments matches all characters in the given arguments of $value$plusargs or $test$plusargs, the function will return a non-zero value.\n\nThis behaviour may lead to the unintentional setting of some flags by aliasing them.\n\nExample:\n\nbit disable_err_msg_1 = ($test$plusargs(\"disable_err_msg_1\") != 0);\nbit disable_err_msg_1234 = ($test$plusargs(\"disable_err_msg_1234\") != 0);\n\nIf a simulation is launched with \"+disable_err_msg_1234\", both the flags above will get set, as disable_err_msg_1234 is aliasing disable_err_msg1.\n\nCheck supports pre-waiving.")
public class Check_R_1066
extends OVMComplianceCheck {
    private static final String VALUE_PLUSARGS = "$value$plusargs";
    private static final String TEST_PLUSARGS = "$test$plusargs";
    private Map<DVTPair<ParserPath, HidOccurrence>, String> checkedPlusargs;

    public Check_R_1066(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkedPlusargs = new HashMap<DVTPair<ParserPath, HidOccurrence>, String>();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new PlusArgsMethodsVisitor());
        ArrayList<Map.Entry<DVTPair<ParserPath, HidOccurrence>, String>> sortedCheckedPlusargs = new ArrayList<Map.Entry<DVTPair<ParserPath, HidOccurrence>, String>>();
        sortedCheckedPlusargs.addAll(this.checkedPlusargs.entrySet());
        Collections.sort(sortedCheckedPlusargs, (o1, o2) -> {
            String val1 = (String)o1.getValue();
            String val2 = (String)o2.getValue();
            if (val1 == null || val2 == null) {
                return 0;
            }
            if (!val1.equals(val2)) {
                return val1.compareTo(val2);
            }
            return ((ParserPath)((DVTPair)o1.getKey()).getKey()).path.compareTo(((ParserPath)((DVTPair)o2.getKey()).getKey()).path);
        });
        int i = 0;
        while (i < sortedCheckedPlusargs.size()) {
            Map.Entry entry1 = (Map.Entry)sortedCheckedPlusargs.get(i);
            String val1 = (String)entry1.getValue();
            if (!"".equals(val1)) {
                StringBuilder hitLinksBuilder = new StringBuilder();
                int j = 0;
                while (j < sortedCheckedPlusargs.size()) {
                    if (i != j) {
                        Map.Entry entry2 = (Map.Entry)sortedCheckedPlusargs.get(j);
                        String val2 = (String)entry2.getValue();
                        String path2 = ((ParserPath)((DVTPair)entry2.getKey()).getKey()).path;
                        HidOccurrence occurence2 = (HidOccurrence)((DVTPair)entry2.getKey()).getValue();
                        int line2 = occurence2.getLine();
                        if (!"".equals(val2) && !val1.equals(val2) && val1.startsWith(val2)) {
                            hitLinksBuilder.append("\n" + this.link("\"" + val2 + "\" at line " + line2 + " in file " + LintUtils.getFileShortName(path2), path2, line2));
                        }
                    }
                    ++j;
                }
                String hitLinks = hitLinksBuilder.toString();
                if (!hitLinks.isEmpty()) {
                    this.addHit((ParserPath)((DVTPair)entry1.getKey()).getKey(), (HidOccurrence)((DVTPair)entry1.getKey()).getValue(), "Plusarg specified string \"" + val1 + "\" is aliasing plusarg strings:" + hitLinks);
                }
            }
            ++i;
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class PlusArgsMethodsVisitor
    implements IHidVisitor<RfHid> {
        ParserPath parserPath;

        private PlusArgsMethodsVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            Check_R_1066.this.notifyCheckAlive();
            if (Check_R_1066.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfPredefinedFunction) || !hidObject.getName().startsWith(Check_R_1066.TEST_PLUSARGS) && !hidObject.getName().startsWith(Check_R_1066.VALUE_PLUSARGS)) {
                return true;
            }
            HidAccess firstAccess = hidObject.getFirstAccess();
            if (firstAccess == null || !(firstAccess instanceof RfHidAccessArgs)) {
                return true;
            }
            HidOccurrence occurence = hidObject.getOccurrence();
            List<? extends IHidObject> args = ((RfHidAccessArgs)firstAccess).getArgumentValues();
            for (IHidObject iHidObject : args) {
                this.checkFunctionArgumentValue(iHidObject, occurence);
            }
            return true;
        }

        private void checkFunctionArgumentValue(IHidObject arg, HidOccurrence occurence) {
            RfHidImplicit implicitHid;
            String implicitString;
            if (arg instanceof HidOperator && ((HidOperator)arg).isAssociation()) {
                HidOperator operator = (HidOperator)arg;
                ListContainer rhVals = operator.getRHValues();
                if (rhVals == null) {
                    return;
                }
                for (IHidObject rhVal : rhVals) {
                    this.checkFunctionArgumentValue(rhVal, (HidOccurrence)operator.getOccurrence());
                }
            } else if (arg instanceof RfHidImplicit && (implicitString = (implicitHid = (RfHidImplicit)arg).toString()) != null && implicitString.length() > 0 && implicitHid.isStringLiteral() && !implicitString.contains("%")) {
                Check_R_1066.this.checkedPlusargs.put((DVTPair<ParserPath, HidOccurrence>)new DVTPair((Object)this.parserPath, (Object)occurence), implicitString.substring(1, implicitString.length() - 1));
            }
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

