/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.42")
@CheckID(value="R.1067")
@CheckName(value="R.1067")
@CheckLabel(labels={RuleLabel.PREDEFINED_METHOD, RuleLabel.PERFORMANCE, RuleLabel.INITIAL})
@CheckTitle(value="Use plusargs only in initial blocks")
@CheckDescription(value="$value$plusargs and $test$plusargs should only be used inside an initial block, as plusargs inside an always or forever block would be time consuming and the return value cannot change during simulation.\n\nCheck supports pre-waiving.")
public class Check_R_1067
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of full names of methods where plusargs can be used.", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMethods;
    private static final String VALUE_PLUSARGS = "$value$plusargs";
    private static final String TEST_PLUSARGS = "$test$plusargs";

    public Check_R_1067(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                Check_R_1067.this.notifyCheckAlive();
                if (Check_R_1067.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (this.holder == null) {
                    return true;
                }
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement enclosingScope = ((HidHolder)this.holder).getScope();
                while (enclosingScope != null) {
                    if (enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isInitial()) {
                        return true;
                    }
                    if (enclosingScope instanceof RfFunction && Check_R_1067.this.pSkipMethods.contains(((RfFunction)enclosingScope).getFullName())) {
                        return true;
                    }
                    enclosingScope = enclosingScope.getEnclosingScope();
                }
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfPredefinedFunction) || !hidObject.getName().startsWith(Check_R_1067.TEST_PLUSARGS) && !hidObject.getName().startsWith(Check_R_1067.VALUE_PLUSARGS)) {
                    return true;
                }
                HidOccurrence occurence = hidObject.getOccurrence();
                Check_R_1067.this.addHit(this.parserPath, occurence, String.valueOf(hidObject.getName()) + " is used outside of initial block!");
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

