/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractPathIncludeCheck;

@CheckVersion(value="25.1.10")
@CheckID(value="R.1068")
@CheckName(value="R.1068")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.INCLUDE})
@CheckTitle(value="Do not use '.' and '..' in include statements")
@CheckDescription(value="Using relative path references such as the current directory reference (\".\") or the parent directory reference (\"..\") in include statement is not allowed.\nFor clarity, it's recommended to include the parent folder in the compilation using an +incdir or use the explicit relative path to another parent incdir.\n\nNot allowed:\n`include \"../example.sv\"\n\nAllowed:\n`include \"incdir/example.sv\"\n\nCheck supports pre-waiving.")
public class Check_R_1068
extends AbstractPathIncludeCheck {
    private static final String CURRENT_DIR_REFERENCE = ".";
    private static final String PARENT_DIR_REFERENCE = "..";

    public Check_R_1068(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void analyzeFilePath(String filePath, ParserPath path, int lineNumber) {
        filePath = filePath.substring(1, filePath.length() - 1);
        List<String> pathSegments = this.splitPathInSegments(filePath);
        for (String segment : pathSegments) {
            if (!CURRENT_DIR_REFERENCE.equals(segment) && !PARENT_DIR_REFERENCE.equals(segment)) continue;
            this.addHit(path, lineNumber, "Using relative path reference inside the '" + filePath + "' path is not allowed, use the explicit path to the incdir instead!", null);
            break;
        }
    }

    private List<String> splitPathInSegments(String filePath) {
        String[] pathsSplit;
        ArrayList<String> pathsArray = new ArrayList<String>();
        String[] stringArray = pathsSplit = DVTStringUtil.split((String)File.separator, (String)filePath);
        int n = pathsSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSplit = stringArray[n2];
            if (!pathSplit.trim().isEmpty()) {
                pathsArray.add(pathSplit);
            }
            ++n2;
        }
        return pathsArray;
    }
}

