/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

@CheckVersion(value="21.1.43")
@CheckID(value="R.1069")
@CheckName(value="R.1069")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.LOOP, RuleLabel.ARRAY, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use foreach to iterate over associative arrays")
@CheckDescription(value="Ordering of associative arrays with indexes of type class and unpacked struct is not defined by the standard and tools may implement it differently.\nObjects can get ordered depending on their memory location which can differ from run to run.\nFor such cases it is recommended to use an explicit sorting before iterating.\nFurthermore, when iterating over associative arrays, no matter their index type, some users may expect the sorted order, while others might expect the insert order.\n\nExample:\n\nmy_class assoc_arr[my_class];\nforeach (assoc_arr[class_index]) begin // not allowed\n...\nmy_class class_array[my_class];\nmy_class idx_instances_q[$];\nidx_instances_q = class_array.find_index() with (1);\nidx_instances_q.sort(idx_inst) with ( (idx_inst != null) ? idx_inst.id : -1 ); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1069
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="struct, class", description="The associative array index type. Possible values: integral, string, struct, class", name="arrayIndexType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pArrayIndexType;

    public Check_R_1069(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                Check_R_1069.this.notifyCheckAlive();
                if (Check_R_1069.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!operator.isForeachCondition()) {
                    return true;
                }
                IHidObject lhVal = operator.getLHValue();
                if (!(lhVal instanceof RfHidAccess)) {
                    return true;
                }
                Hid parent = ((RfHidAccess)lhVal).getParentHid();
                if (parent == null) {
                    return true;
                }
                IRfNamedElement elem = parent.getElement();
                if (!(elem instanceof RfAssociatedType)) {
                    return true;
                }
                IRfNamedElement elemAssocType = ((RfAssociatedType)elem).getAssociatedType();
                if (!(elemAssocType instanceof RfListType) || !((RfListType)elemAssocType).isAssociativeArray()) {
                    return true;
                }
                RfListType assocArray = (RfListType)elemAssocType;
                IRfNamedElement indexType = assocArray.getIndexType();
                if (indexType == null) {
                    return true;
                }
                if (indexType instanceof RfStringType && !Check_R_1069.this.pArrayIndexType.contains("string")) {
                    return true;
                }
                if ((indexType instanceof RfBitVectorScalarType || indexType instanceof RfStruct && ((RfStruct)indexType).isPacked()) && !Check_R_1069.this.pArrayIndexType.contains("integral")) {
                    return true;
                }
                if (indexType instanceof RfClass && !Check_R_1069.this.pArrayIndexType.contains("class")) {
                    return true;
                }
                if (indexType instanceof RfStruct && !((RfStruct)indexType).isPacked() && !Check_R_1069.this.pArrayIndexType.contains("struct")) {
                    return true;
                }
                Check_R_1069.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Foreach is used to iterate over associative array '" + LintUtils.getNamedElementFullName((RfNamedElement)elem) + "'!");
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

