/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractForLoopCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.43")
@CheckID(value="R.1070")
@CheckName(value="R.1070")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.LOOP, RuleLabel.INITIALIZATION})
@CheckTitle(value="Do not use for loops without initialization")
@CheckDescription(value="This rule flags for loops without the initialization step.\nHaving the initialization in the for loops offers a clearer picture of the loop.\n\nExamples:\nfor (int i = 0; i < 10; i++) // allowed\n\ta += i;\nfor ( ; j < 10; j++) // not allowed\n\tb += j;\n\nCheck supports pre-waiving.")
public class Check_R_1070
extends AbstractForLoopCheck {
    public Check_R_1070(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean checkLoopOperators(ListContainer<IHidObject> loopOperators) {
        for (IHidObject operator : loopOperators) {
            if (!(operator instanceof RfHidOperator) || !((RfHidOperator)operator).isForInit()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getHitMessage() {
        return "For loop without initialization is not allowed!";
    }

    @Override
    protected void addHits(RfNamedElement namedElement) {
        this.addHit(namedElement, this.getHitMessage());
    }
}

