/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="21.1.43")
@CheckID(value="R.1071")
@CheckName(value="R.1071")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.STYLING, RuleLabel.PORT, RuleLabel.DESIGN})
@CheckTitle(value="The same declaration style(ANSI/non-ANSI) must be used for all modules")
@CheckDescription(value="This check determines the declaration style used by most of the modules in the project and flags the modules that are not using it.\nA particular declaration style can be enforced by setting the <styleName> parameter to 'ANSI' or 'non-ANSI'.\nModules without ports will be skipped.\n\nCheck supports pre-waiving.")
public class Check_R_1071
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="The name of the header style that must be used in the modules definition. One of ANSI, non-ANSI. When empty the declaration style used by most modules will be considered.", name="styleName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pStyleName;

    public Check_R_1071(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<IRfPortElement> modulePorts;
        int ansiCounter = 0;
        int nonAnsiCounter = 0;
        NullProtectedList<RfNamedElement> allModules = this.fOVMProject.getAllModules();
        if (this.pStyleName.isEmpty()) {
            for (RfNamedElement module : allModules) {
                this.notifyCheckAlive();
                if (!(module instanceof RfModule) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(module.getDeclaration().getParserPath(), this) || (modulePorts = ((RfModule)module).getLocalPorts()) == null || modulePorts.isEmpty()) continue;
                if (((RfModule)module).isNonAnsi()) {
                    ++nonAnsiCounter;
                    continue;
                }
                ++ansiCounter;
            }
        }
        for (RfNamedElement module : allModules) {
            this.notifyCheckAlive();
            if (!(module instanceof RfModule) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(module.getDeclaration().getParserPath(), this) || (modulePorts = ((RfModule)module).getLocalPorts()) == null || modulePorts.isEmpty()) continue;
            if (this.pStyleName.isEmpty()) {
                this.localAddHit((RfModule)module, ansiCounter, nonAnsiCounter);
                continue;
            }
            if (this.pStyleName.equals("ANSI") && ((RfModule)module).isNonAnsi()) {
                this.addHit(module, "Module '" + module.getName() + "' is declared using the non-ANSI header style!");
                continue;
            }
            if (!this.pStyleName.equals("non-ANSI") || ((RfModule)module).isNonAnsi()) continue;
            this.addHit(module, "Module '" + module.getName() + "' is declared using the ANSI header style!");
        }
    }

    private void localAddHit(RfModule module, int ansiCounter, int nonAnsiCounter) {
        if (nonAnsiCounter <= ansiCounter && module.isNonAnsi()) {
            this.addHit(module, "Module '" + module.getName() + "' is declared using the non-ANSI header style, most modules are using the ANSI style!");
        } else if (nonAnsiCounter > ansiCounter && !module.isNonAnsi()) {
            this.addHit(module, "Module '" + module.getName() + "' is declared using the ANSI header style, most modules are using the non-ANSI style!");
        }
    }
}

