/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.47")
@CheckID(value="R.1073")
@CheckName(value="R.1073")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Do not use traversal methods for associative arrays")
@CheckDescription(value="This rule flags the usage of 'prev', 'next', 'first', 'last' predefined methods for the associative arrays that have the index type specified by the <arrayIndexType> parameter.\nOrdering of associative arrays with indexes of type class and unpacked struct is not defined by the standard and tools may implement it differently.\nObjects can get ordered depending on their memory location which can differ from run to run.\nFor such cases it is recommended to use an explicit sorting before iterating.\nFurthermore, when iterating over associative arrays, no matter their index type, some users may expect the sorted order, while others might expect the insert order.\n\nExample:\n\nmy_class assoc_arr[my_class];\nassoc_arr.first(my_class_inst) // not allowed\n...\nmy_class class_array[my_class];\nmy_class idx_instances_q[$];\nidx_instances_q = class_array.find_index() with (1);\nidx_instances_q.sort(idx_inst) with ( (idx_inst != null) ? idx_inst.id : -1 ); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1073
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="struct, class", description="The associative array index type. Possible values: integral, string, struct, class", name="arrayIndexType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pArrayIndexType;
    private static final Set<String> ITERATION_FUNCTIONS = new HashSet<String>(Arrays.asList("prev", "last", "next", "first"));

    public Check_R_1073(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                Check_R_1073.this.notifyCheckAlive();
                if (Check_R_1073.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!hidObject.isMethodCall(true)) {
                    return true;
                }
                IRfNamedElement elem = hidObject.getElement();
                if (!(elem instanceof RfPredefinedFunction) || !ITERATION_FUNCTIONS.contains(elem.getName())) {
                    return true;
                }
                IRfScopeElement enclosingScope = elem.getEnclosingScope();
                if (!(enclosingScope instanceof RfListType) || !((RfListType)enclosingScope).isAssociativeArray()) {
                    return true;
                }
                RfListType assocArray = (RfListType)enclosingScope;
                DataType type = assocArray.getIndexTypeRaw();
                if (type == null) {
                    return true;
                }
                if (type.isPredefinedType()) {
                    if (type.getType().equals("string") && !Check_R_1073.this.pArrayIndexType.contains("string")) {
                        return true;
                    }
                    if (LintUtils.INTEGRAL_BASE_TYPES.contains(type.getType()) && !Check_R_1073.this.pArrayIndexType.contains("integral")) {
                        return true;
                    }
                }
                if (!type.isPredefinedType()) {
                    IRfNamedElement typeElement = assocArray.getIndexType();
                    if (typeElement instanceof RfTypeAlias) {
                        typeElement = LintUtils.getAssociatedFinalType((RfTypeAlias)typeElement);
                    }
                    if (!(typeElement instanceof RfClass) && !(typeElement instanceof RfStruct)) {
                        return true;
                    }
                    if (typeElement instanceof RfStruct ? (typeElement instanceof RfStruct && ((RfStruct)typeElement).isPacked() ? !Check_R_1073.this.pArrayIndexType.contains("integral") : typeElement instanceof RfStruct && !Check_R_1073.this.pArrayIndexType.contains("struct") || typeElement instanceof RfClass && !Check_R_1073.this.pArrayIndexType.contains("class")) : typeElement instanceof RfClass && !Check_R_1073.this.pArrayIndexType.contains("class")) {
                        return true;
                    }
                }
                Check_R_1073.this.addHit(this.parserPath, hidObject.getOccurrence(), "Traversal method '" + elem.getName() + "' is used to iterate over associative array '" + LintUtils.getNamedElementFullName((RfNamedElement)elem.getEnclosingScope()) + "'!");
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

