/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.18")
@CheckID(value="R.1108")
@CheckName(value="R.1108")
@CheckLabel(labels={RuleLabel.CONFIG_DB, RuleLabel.BUILD_PHASE, RuleLabel.CONSTRUCTOR, RuleLabel.PERFORMANCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use uvm_config_db::set/get outside build_phase/constructor for components/objects")
@CheckDescription(value="The uvm_config_db::set/get methods can be time consuming and this is why such calls should not be made outside build_phase/constructor for components/objects.\n\nExamples:\nvirtual function void build_phase(uvm_phase phase);\n\tuvm_config_db#(virtual interface1)::set(this, \"instance_name\", \"field_name\", top.module1_u.interface1_u); // ALLOWED\n\tuvm_config_db#(virtual interface1)::get(this, \"instance_name\", \"field_name\", top.module1_u.interface1_u); // ALLOWED\nendfunction : build_phase\n\nvirtual function void body(uvm_phase phase);\n\tuvm_config_db#(virtual interface1)::set(this, \"instance_name\", \"field_name\", top.module1_u.interface1_u); // NOT ALLOWED\n\tuvm_config_db#(virtual interface1)::get(this, \"instance_name\", \"field_name\", top.module1_u.interface1_u); // NOT ALLOWED\nendfunction : build_phase\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1108
extends OVMComplianceCheck {
    private static final String NEW = "new";
    private static final String UVM_SEQUENCE_NAME = "uvm_pkg::uvm_sequence";
    @CheckParameter(defaultValue="false", description="When true, the use of uvm_config_db::set/get calls is allowed in a function called from the build_phase respectively constructor methods.", name="allowIndirectCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowIndirectCallsValue;
    @CheckParameter(defaultValue="false", description="When true, the use of uvm_config_db::set/get calls is allowed in the sequence body.", name="allowCallsInBody", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowCallsInBodyValue;
    LinkedHashMap<RfFunction, List<RfHid>> checkHits = new LinkedHashMap();

    public Check_R_1108(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass objectClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_object", true);
        if (objectClass == null) {
            return;
        }
        RfClass sequenceClass = this.fOVMProject.getRfProject().getClass(UVM_SEQUENCE_NAME, true);
        if (sequenceClass == null) {
            return;
        }
        Set<RfClass> allObjects = this.fOVMProject.getAllXVMSubClasses(objectClass);
        if (allObjects.isEmpty()) {
            return;
        }
        for (RfClass clazz : allObjects) {
            List<RfFunction> functions;
            ParserPath classParserPath;
            RfFileDef classFile = clazz.getFile();
            if (classFile == null || (classParserPath = classFile.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.notifyCheckAlive();
            List<RfClass> parentList = this.getClassHierarchy(clazz);
            RfFunction buildPhase = this.getFirstParentBuildPhase(clazz);
            RfFunction constructor = clazz.getConstructorWithPrefix(NEW, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            RfFunction bodyFunction = null;
            if (LintUtils.isSubClassOf(clazz, sequenceClass)) {
                bodyFunction = clazz.getTaskWithPrefix("body", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if ((functions = clazz.getLocalMembers(RfFunction.class)) == null || functions.isEmpty()) continue;
            for (RfFunction rfFunction : functions) {
                if (this.fOVMProject.isOVMElement(rfFunction) || rfFunction.isPredefined()) continue;
                this.notifyCheckAlive();
                if (rfFunction.equals(buildPhase) || rfFunction.equals(constructor) || this.pAllowCallsInBodyValue && bodyFunction != null && rfFunction.equals(bodyFunction)) continue;
                rfFunction.visitHidObject(this.fOVMProject.getRfProject(), new ClassMethodVisitor(rfFunction));
            }
            if (this.pAllowIndirectCallsValue) {
                if (buildPhase != null) {
                    buildPhase.visitHidObject(this.fOVMProject.getRfProject(), new MethodCallTreeVisitor(parentList, new ArrayList<RfFunction>()));
                }
                if (constructor != null) {
                    constructor.visitHidObject(this.fOVMProject.getRfProject(), new MethodCallTreeVisitor(parentList, new ArrayList<RfFunction>()));
                }
                if (this.pAllowCallsInBodyValue && bodyFunction != null) {
                    bodyFunction.visitHidObject(this.fOVMProject.getRfProject(), new MethodCallTreeVisitor(parentList, new ArrayList<RfFunction>()));
                }
            }
            for (Map.Entry entry : this.checkHits.entrySet()) {
                List hids = (List)entry.getValue();
                for (RfHid hid : hids) {
                    this.addHit(classParserPath, hid, "Function " + HidUtils.toNiceString((IHidObject)hid) + " called outside build_phase() method!");
                }
            }
            this.checkHits.clear();
        }
    }

    private List<RfClass> getClassHierarchy(RfClass clazz) {
        ArrayList<RfClass> result = new ArrayList<RfClass>();
        result.add(clazz);
        RfClass parentClass = clazz.getParent();
        while (parentClass != null && !this.fOVMProject.isOVMElement(parentClass)) {
            result.add(parentClass);
            parentClass = parentClass.getParent();
        }
        return result;
    }

    private RfFunction findMethodImplementation(List<RfClass> parentList, RfFunction localFunction) {
        if (parentList == null || parentList.isEmpty()) {
            return null;
        }
        for (RfClass parent : parentList) {
            RfFunction childCall = null;
            if (localFunction.isFunction()) {
                childCall = parent.getFunctionWithPrefix(localFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            } else if (localFunction.isTask()) {
                childCall = parent.getTaskWithPrefix(localFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (childCall == null) continue;
            return childCall;
        }
        return null;
    }

    private boolean isSuper(RfHid hid) {
        HidAccess hidAccess = hid.getParentAccess();
        if (hidAccess == null) {
            return false;
        }
        Hid parentHid = hidAccess.getParentHid();
        if (parentHid == null) {
            return false;
        }
        return parentHid.getName().startsWith("super");
    }

    private RfFunction getFirstParentBuildPhase(RfClass clazz) {
        if (clazz == null) {
            return null;
        }
        RfFunction searchedParentElement = clazz.getFunctionWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (searchedParentElement == null) {
            return this.getFirstParentBuildPhase(clazz.getParent());
        }
        return searchedParentElement;
    }

    public boolean isSetOrGetConfigurationFunction(RfHid hid) {
        HidAccess parentAccess = hid.getParentAccess();
        IRfNamedElement associatedType = parentAccess != null ? (parentAccess.getAssociatedType() instanceof RfAssociatedType ? LintUtils.getAssociatedFinalType((RfAssociatedType)parentAccess.getAssociatedType()) : parentAccess.getAssociatedType()) : null;
        IRfNamedElement hidNamedElement = hid.getElement();
        if (hidNamedElement == null) {
            return false;
        }
        String hidName = hidNamedElement.getName();
        if (hidName == null) {
            return false;
        }
        return !(!"set".equals(hidNamedElement.getName()) && !"get".equals(hidNamedElement.getName()) || !(associatedType instanceof RfClass) || !"uvm_config_db".equals(associatedType.getName()) && !((RfClass)associatedType).isSubClass("uvm_config_db", true));
    }

    private class ClassMethodVisitor
    extends RfHidVisitor {
        private RfFunction function;

        public ClassMethodVisitor(RfFunction function) {
            this.function = function;
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction localFunctionCall = (RfFunction)hidNamedElement;
            String functionName = localFunctionCall.getName();
            if (functionName == null) {
                return true;
            }
            if (!Check_R_1108.this.isSetOrGetConfigurationFunction(hid)) {
                return true;
            }
            Check_R_1108.this.notifyCheckAlive();
            this.addHidToMap(hid, Check_R_1108.this.checkHits);
            return true;
        }

        private void addHidToMap(RfHid hid, LinkedHashMap<RfFunction, List<RfHid>> postStartHits) {
            List<RfHid> hidsList = postStartHits.get(this.function);
            if (hidsList == null) {
                hidsList = new ArrayList<RfHid>();
            }
            hidsList.add(hid);
            postStartHits.put(this.function, hidsList);
        }
    }

    private class MethodCallTreeVisitor
    extends RfHidVisitor {
        private List<RfClass> parentList;
        private List<RfFunction> visitedFunction;

        public MethodCallTreeVisitor(List<RfClass> parentList, List<RfFunction> visitedFunction) {
            this.parentList = parentList;
            this.visitedFunction = visitedFunction;
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction localFunction = (RfFunction)hidNamedElement;
            if (localFunction.isPredefined()) {
                return true;
            }
            if (Check_R_1108.this.fOVMProject.isOVMElement(localFunction)) {
                return true;
            }
            Check_R_1108.this.notifyCheckAlive();
            RfFunction tmpFunc = null;
            tmpFunc = Check_R_1108.this.isSuper(hid) && !this.parentList.isEmpty() ? Check_R_1108.this.findMethodImplementation(this.parentList.subList(1, this.parentList.size()), localFunction) : Check_R_1108.this.findMethodImplementation(this.parentList, localFunction);
            if (tmpFunc != null) {
                localFunction = tmpFunc;
            }
            if (this.visitedFunction.contains(localFunction)) {
                return true;
            }
            if (Check_R_1108.this.checkHits.containsKey(localFunction)) {
                Check_R_1108.this.checkHits.remove(localFunction);
            }
            this.visitedFunction.add(localFunction);
            localFunction.visitHidObject(Check_R_1108.this.fOVMProject.getRfProject(), new MethodCallTreeVisitor(this.parentList, this.visitedFunction));
            this.visitedFunction.remove(localFunction);
            return true;
        }
    }
}

