/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="22.1.6")
@CheckID(value="R.1109")
@CheckName(value="R.1109")
@CheckLabel(labels={RuleLabel.CONSTRUCTOR, RuleLabel.PREDEFINED_METHOD, RuleLabel.RANDOMIZATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not call srandom outside of the class constructor")
@CheckDescription(value="This rule checks that the srandom() method is used only inside the constructor of a class.\nMethod srandom() should be seeded in constructor in order to avoid races.\n\nExamples:\nclass my_class;\n\n  function new()\n    this.srandom(10); // allowed\n  endfunction\n\n  function foo()\n    this.srandom(12); // not allowed\n  endfunction\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1109
extends OVMComplianceCheck {
    public Check_R_1109(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        LocalHidVisitor callVisitor = new LocalHidVisitor();
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            RfFileDef file;
            if (!(function instanceof RfFunction) || ((RfFunction)function).isConstructor() || (file = function.getFile()) == null || file.getParserPath() == null || this.checkPrewaivers(file.getParserPath())) continue;
            callVisitor.setFuncName(function.getName());
            function.visitHidObject(null, callVisitor);
        }
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        String funcName;

        LocalHidVisitor() {
        }

        public void setFuncName(String funcName) {
            this.funcName = funcName;
        }

        public boolean visit(RfHid rfHid) {
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfPredefinedFunction)) {
                return true;
            }
            if (!rfHid.getName().equals("srandom")) {
                return true;
            }
            Check_R_1109.this.addHit(this.parserPath, rfHid, "Method " + this.funcName + "()' calls srandom()'");
            return true;
        }
    }
}

