/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFourStateCastCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.50")
@CheckID(value="R.1110")
@CheckName(value="R.1110")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.METHOD, RuleLabel._4_STATE, RuleLabel.CAST})
@CheckTitle(value="Method calls with 4 state values for 2 state arguments must include X, Z check")
@CheckDescription(value="SystemVerilog does not require a compiler check when casting from 4 state to 2 state types.\nWhen an X or Z is assigned to a 2 state type the value is silently converted to 0.\nSince this is not typically intended, it is recommended to frame any 4 state to 2 state cast with a check for X or Z.\n\nCheck supports pre-waiving.")
public class Check_R_1110
extends AbstractFourStateCastCheck {
    @CheckParameter(defaultValue="$bits, $left, $right, $low, $high, $increment, $size, $dimensions, $unpacked_dimensions", description="Comma separated list of method names returning a 4 state type used as argument value to be skipped.", name="skipMethodCallsAsArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipMethodCallsAsArguments;
    private final RfHidVisitor methodCallVisitor = new RfHidVisitor(){
        private ParserPath parserPath;
        private IRfNamedElement scope;

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        public boolean visit(RfHid hidObject) {
            RfNamedElement functionScope;
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1110.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1110.this.notifyCheckAlive();
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (function instanceof RfPredefinedFunction && !((functionScope = function.getEnclosingScope()) instanceof RfListType)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null) continue;
                for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                    RfFunction argumentMethod;
                    IRfNamedElement argumentMethodElement;
                    String numberString;
                    IRfNamedElement argumentFieldType;
                    IRfNamedElement argumentField = (IRfNamedElement)argument.getKey();
                    if (!(argumentField instanceof RfAssociatedType) || LintUtils.isFourStateType(argumentFieldType = ((RfAssociatedType)argumentField).getAssociatedType(), Check_R_1110.this.pHandleTimeAsFourStateValue)) continue;
                    IHidObject iHid = (IHidObject)argument.getValue();
                    RfHid argumentValueHid = null;
                    IRfNamedElement argumentType = null;
                    if (iHid instanceof RfHidAccessArgs) {
                        iHid = ((RfHidAccessArgs)iHid).getParentHid();
                    }
                    if (iHid instanceof RfHidAccess) {
                        RfHidAccess hidAccess = (RfHidAccess)iHid;
                        argumentValueHid = (RfHid)hidAccess.getParentHid();
                        argumentType = hidAccess.getAssociatedType();
                    } else if (iHid instanceof RfHid) {
                        argumentValueHid = (RfHid)iHid;
                        IRfNamedElement argumentElement = argumentValueHid.getElement();
                        if (!(argumentElement instanceof RfAssociatedType)) continue;
                        argumentType = ((RfAssociatedType)argumentElement).getAssociatedType();
                    } else if (iHid instanceof RfHidImplicit && ((RfHidImplicit)iHid).isNumber() && ((RfHidImplicit)iHid).getType() != 283 && ((numberString = ((RfHidImplicit)iHid).getName()).toUpperCase().contains("X") || numberString.toUpperCase().contains("Z")) && !LintUtils.isInConditionalActionBlock((IRfScope)this.scope)) {
                        Check_R_1110.this.addHit(this.parserPath, hidObject, Check_R_1110.this.getFailMessage(argumentField, numberString));
                        continue;
                    }
                    if (argumentType == null || argumentValueHid == null || !LintUtils.isFourStateType(argumentType, Check_R_1110.this.pHandleTimeAsFourStateValue) || argumentValueHid.isMethodCall(false) && (argumentMethodElement = argumentValueHid.getElement()) instanceof RfFunction && Check_R_1110.this.pSkipMethodCallsAsArguments.contains((argumentMethod = (RfFunction)argumentMethodElement).getFullName())) continue;
                    if (!LintUtils.isInConditionalActionBlock((IRfScope)this.scope)) {
                        Check_R_1110.this.addHit(this.parserPath, hidObject, Check_R_1110.this.getFailMessage(argumentField, argumentValueHid.getName()));
                        continue;
                    }
                    IHidObject ifObject = Check_R_1110.this.getFirstConditionalWithExpressionBlock((IRfScope)this.scope);
                    if (ifObject == null) continue;
                    Check_R_1110.this.checkConditionalActionBlock(this.scope, ifObject);
                    Set associatedFields = (Set)Check_R_1110.this.fields.get(this.scope);
                    if (associatedFields.contains((Object)argumentValueHid)) continue;
                    Check_R_1110.this.addHit(this.parserPath, hidObject, Check_R_1110.this.getFailMessage(argumentField, argumentValueHid.getName()));
                }
            }
            return true;
        }
    };

    public Check_R_1110(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fields.clear();
        this.fOVMProject.getRfProject().visitHidObject(null, this.methodCallVisitor);
    }

    private String getFailMessage(IRfNamedElement argument, String argumentName) {
        return "Unchecked method call of 2 state argument '" + argument.getName() + "' with a 4 state value: " + argumentName;
    }

    @Override
    public void clean() {
        super.clean();
        if (this.fields != null) {
            this.fields.clear();
        }
    }
}

