/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractRaiseAndDropObjectionCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1111")
@CheckName(value="R.1111")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.OBJECTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Raised objections must be dropped")
@CheckDescription(value="This rule flags methods that raise an objection and do not drop it.\n\nExample:\ntask run_phase(uvm_phase phase);\n // We raise objection to keep the test from completing\n phase.raise_objection(this);\n begin\n my_sequence seq;\n seq = my_sequence::type_id::create(\"seq\");\n seq.start(sequencer);\n end\n // We drop the objection to allow the test to complete. Without this, the test hangs\n // phase.drop_objection(this);\n endtask")
public class Check_R_1111
extends AbstractRaiseAndDropObjectionCheck {
    public Check_R_1111(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    void checkRaiseAndDropCalls(List<AbstractRaiseAndDropObjectionCheck.ObjectionInfo> raiseArguments, List<AbstractRaiseAndDropObjectionCheck.ObjectionInfo> dropArguments, ParserPath classParserPath, RfFunction function) {
        for (AbstractRaiseAndDropObjectionCheck.ObjectionInfo raiseObjectionInfo : raiseArguments) {
            RfHid raiseHid = raiseObjectionInfo.getObjectionCall();
            RfHid raiseArg = raiseObjectionInfo.getObjectionParam();
            AbstractRaiseAndDropObjectionCheck.ObjectionInfo associatedDropObjectionInfo = null;
            for (AbstractRaiseAndDropObjectionCheck.ObjectionInfo dropObjectionInfo : dropArguments) {
                RfHid dropArg;
                RfHid dropHid = dropObjectionInfo.getObjectionCall();
                if (!this.checkCorrespondingHid(raiseHid, raiseArg, dropHid, dropArg = dropObjectionInfo.getObjectionParam())) continue;
                associatedDropObjectionInfo = dropObjectionInfo;
                break;
            }
            if (associatedDropObjectionInfo == null) {
                this.addHit(classParserPath, raiseHid.getOccurrence(), "Raised objection was not dropped for object: '" + raiseArg.getName() + "' in method: '" + LintUtils.getNamedElementFullName(function) + "'!");
                continue;
            }
            dropArguments.remove(associatedDropObjectionInfo);
        }
    }
}

