/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessVisitor;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.50")
@CheckID(value="R.1112")
@CheckName(value="R.1112")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Always call item_done after get_next_item")
@CheckDescription(value="Always call item_done() after get_next_item() to prevent a possible simulation hang.\nBoth calls must be in the same method scope.\n\nExamples:\ntask run_phase(uvm_phase phase);\n  uvm_sequencer my_seq;\n  uvm_sequence_item my_item;\n  my_seq.get_next_item(my_item);  //not allowed\nendtask : run_phase\n\ntask run_phase(uvm_phase phase);\n  uvm_sequencer my_seq;\n  uvm_sequence_item my_item;\n  my_seq.get_next_item(my_item);  //allowed\n  my_seq.item_done(my_item);\nendtask : run_phase\n\nCheck supports pre-waiving.")
public class Check_R_1112
extends OVMComplianceCheck {
    private Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> getNextItemCalls = new HashMap<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>>();
    private Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> itemDoneCalls = new HashMap<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>>();
    private static final String HIT_MESSAGE_FORMAT = "get_next_item called on sequencer:''{0}'' is not followed by an item_done call in method:''{1}''!";

    public Check_R_1112(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.getNextItemCalls.clear();
        this.itemDoneCalls.clear();
        LocalVisitor visitor = new LocalVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        this.getNextItemCalls = visitor.getGetNextItemCalls();
        this.itemDoneCalls = visitor.getItemDoneCalls();
        Set<RfNamedElement> getNextItemScopes = this.getNextItemCalls.keySet();
        for (RfNamedElement scope : getNextItemScopes) {
            this.notifyCheckAlive();
            if (!this.itemDoneCalls.containsKey(scope)) {
                this.addLocalHits(scope);
                continue;
            }
            Set<RfField> getNextItemSequencers = this.getNextItemCalls.get(scope).keySet();
            for (RfField seqField : getNextItemSequencers) {
                if (!this.itemDoneCalls.get(scope).containsKey(seqField)) {
                    this.addLocalHits(scope, seqField);
                    continue;
                }
                Set<IHid> getNextItemArgs = this.getNextItemCalls.get(scope).get(seqField).keySet();
                for (IHid arg : getNextItemArgs) {
                    if (!this.itemDoneCalls.get(scope).get(seqField).containsKey(arg)) {
                        this.addLocalHits(scope, seqField, arg);
                        continue;
                    }
                    Set<HidOccurrence> occurrences = this.getNextItemCalls.get(scope).get(seqField).get(arg);
                    for (HidOccurrence occ : occurrences) {
                        if (this.hasItemDoneCallAfter(scope, seqField, arg, occ)) continue;
                        this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(seqField), LintUtils.getNamedElementFullName(scope)));
                    }
                }
            }
        }
    }

    private boolean hasItemDoneCallAfter(RfNamedElement scope, RfField field, IHid arg, HidOccurrence occ) {
        Set<HidOccurrence> occurrences = this.itemDoneCalls.get(scope).get(field).get(arg);
        for (HidOccurrence itemDoneOcc : occurrences) {
            if (itemDoneOcc.getOffset() <= occ.getOffset()) continue;
            return true;
        }
        return false;
    }

    private void addLocalHits(RfNamedElement scope) {
        Map<RfField, Map<IHid, Set<HidOccurrence>>> map = this.getNextItemCalls.get(scope);
        Set<RfField> fieldSet = map.keySet();
        for (RfField field : fieldSet) {
            Map<IHid, Set<HidOccurrence>> map2 = map.get(field);
            Set<IHid> hidSet = map2.keySet();
            for (IHid hid : hidSet) {
                Set<HidOccurrence> occSet = map2.get(hid);
                for (HidOccurrence occ : occSet) {
                    this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(field), LintUtils.getNamedElementFullName(scope)));
                }
            }
        }
    }

    private void addLocalHits(RfNamedElement scope, RfField field) {
        Map<IHid, Set<HidOccurrence>> map = this.getNextItemCalls.get(scope).get(field);
        Set<IHid> hidSet = map.keySet();
        for (IHid hid : hidSet) {
            Set<HidOccurrence> occSet = map.get(hid);
            for (HidOccurrence occ : occSet) {
                this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(field), LintUtils.getNamedElementFullName(scope)));
            }
        }
    }

    private void addLocalHits(RfNamedElement scope, RfField field, IHid arg) {
        Set<HidOccurrence> occSet = this.getNextItemCalls.get(scope).get(field).get(arg);
        for (HidOccurrence occ : occSet) {
            this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(field), LintUtils.getNamedElementFullName(scope)));
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.getNextItemCalls != null) {
            this.getNextItemCalls.clear();
        }
        if (this.itemDoneCalls != null) {
            this.itemDoneCalls.clear();
        }
    }

    protected class LocalVisitor
    extends RfHidAccessVisitor {
        private RfNamedElement scope;
        private Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> getNextItemCalls = new HashMap<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>>();
        private Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> itemDoneCalls = new HashMap<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>>();

        public boolean visit(RfHidAccess hidObject) {
            if (this.scope.isPredefined()) {
                return true;
            }
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (Check_R_1112.this.fOVMProject.isOVMFile(file.getName())) {
                return true;
            }
            if (Check_R_1112.this.checkPreWaivers(file)) {
                return true;
            }
            RfNamedElement container = this.scope.getClosestTypeContainer();
            if (Check_R_1112.this.fOVMProject.isOVMElement(container)) {
                return true;
            }
            Check_R_1112.this.notifyCheckAlive();
            IRfNamedElement associatedType = hidObject.getAssociatedType();
            if (!(associatedType instanceof RfClass)) {
                return true;
            }
            if (!Check_R_1112.this.fOVMProject.isSequencerOrTheSequencerBaseClass((RfClass)associatedType)) {
                return true;
            }
            ListContainer hids = hidObject.getHids();
            if (hids == null || hids.isEmpty() || hids.size() != 1) {
                return true;
            }
            if (!(hids.get(0) instanceof RfHid)) {
                return true;
            }
            RfHid hid = (RfHid)((Object)hids.get(0));
            if (!hid.isMethodCall(false)) {
                return true;
            }
            if (!hid.getName().equals("get_next_item") && !hid.getName().equals("item_done")) {
                return true;
            }
            Hid parentHid = hid.getParentHid();
            if (!(parentHid.getElement() instanceof RfField)) {
                return true;
            }
            RfField parentElement = (RfField)parentHid.getElement();
            HidOccurrence occurrence = hid.getOccurrence();
            if (hid.getOccurrence() == null) {
                return true;
            }
            if (!(hid.getFirstAccess() instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs access = (RfHidAccessArgs)hid.getFirstAccess();
            List<? extends IHidObject> argumentValues = access.getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty() || argumentValues.size() != 1) {
                return true;
            }
            if (!(argumentValues.get(0) instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator op = (RfHidOperator)argumentValues.get(0);
            ListContainer rhValues = op.getRHValues();
            if (rhValues == null || rhValues.isEmpty() || rhValues.size() != 1) {
                return true;
            }
            if (!(rhValues.get(0) instanceof RfHid) && !(rhValues.get(0) instanceof RfHidImplicit)) {
                return true;
            }
            IHid arg = (IHid)rhValues.get(0);
            RfNamedElement functionScope = this.scope.getEnclosingScope(RfFunction.class);
            if (!(functionScope instanceof RfFunction)) {
                return true;
            }
            if (hid.getName().equals("get_next_item")) {
                if (!this.getNextItemCalls.containsKey(functionScope)) {
                    this.getNextItemCalls.put(functionScope, new HashMap());
                }
                if (!this.getNextItemCalls.get(functionScope).containsKey(parentElement)) {
                    this.getNextItemCalls.get(functionScope).put(parentElement, new HashMap());
                }
                if (!this.getNextItemCalls.get(functionScope).get(parentElement).containsKey(arg)) {
                    this.getNextItemCalls.get(functionScope).get(parentElement).put(arg, new HashSet());
                }
                this.getNextItemCalls.get(functionScope).get(parentElement).get(arg).add(occurrence);
            } else if (hid.getName().equals("item_done")) {
                if (!this.itemDoneCalls.containsKey(this.scope)) {
                    this.itemDoneCalls.put(functionScope, new HashMap());
                }
                if (!this.itemDoneCalls.get(functionScope).containsKey(parentElement)) {
                    this.itemDoneCalls.get(functionScope).put(parentElement, new HashMap());
                }
                if (!this.itemDoneCalls.get(functionScope).get(parentElement).containsKey(arg)) {
                    this.itemDoneCalls.get(functionScope).get(parentElement).put(arg, new HashSet());
                }
                this.itemDoneCalls.get(functionScope).get(parentElement).get(arg).add(occurrence);
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> getGetNextItemCalls() {
            return this.getNextItemCalls;
        }

        public Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> getItemDoneCalls() {
            return this.itemDoneCalls;
        }
    }
}

