/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.Check_R_1112;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.50")
@CheckID(value="R.1113")
@CheckName(value="R.1113")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Always call get_next_item before item_done")
@CheckDescription(value="Method item_done() must be called only with corresponding get_next_item() call.\nBoth calls must be in the same method scope.\n\nExamples:\ntask run_phase(uvm_phase phase);\n  uvm_sequencer my_seq;\n  uvm_sequence_item my_item;\n  my_seq.item_done(my_item);  //not allowed\nendtask : run_phase\n\ntask run_phase(uvm_phase phase);\n  uvm_sequencer my_seq;\n  uvm_sequence_item my_item;\n  my_seq.get_next_item(my_item);\n  my_seq.item_done(my_item);  //allowed\nendtask : run_phase\n\nCheck supports pre-waiving.")
public class Check_R_1113
extends Check_R_1112 {
    private Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> getNextItemCalls = new HashMap<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>>();
    private Map<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>> itemDoneCalls = new HashMap<RfNamedElement, Map<RfField, Map<IHid, Set<HidOccurrence>>>>();
    private static final String HIT_MESSAGE_FORMAT = "item_done called on sequencer:''{0}'' does not have a corresponding get_next_item call in method:''{1}''!";

    public Check_R_1113(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.getNextItemCalls.clear();
        this.itemDoneCalls.clear();
        Check_R_1112.LocalVisitor visitor = new Check_R_1112.LocalVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        this.getNextItemCalls = visitor.getGetNextItemCalls();
        this.itemDoneCalls = visitor.getItemDoneCalls();
        Set<RfNamedElement> itemDoneScopes = this.itemDoneCalls.keySet();
        for (RfNamedElement scope : itemDoneScopes) {
            this.notifyCheckAlive();
            if (!this.getNextItemCalls.containsKey(scope)) {
                this.addHits(scope);
                continue;
            }
            Set<RfField> itemDoneSequencers = this.itemDoneCalls.get(scope).keySet();
            for (RfField seqField : itemDoneSequencers) {
                if (!this.getNextItemCalls.get(scope).containsKey(seqField)) {
                    this.addHits(scope, seqField);
                    continue;
                }
                Set<IHid> itemDoneArgs = this.itemDoneCalls.get(scope).get(seqField).keySet();
                for (IHid arg : itemDoneArgs) {
                    if (!this.getNextItemCalls.get(scope).get(seqField).containsKey(arg)) {
                        this.addHits(scope, seqField, arg);
                        continue;
                    }
                    Set<HidOccurrence> occurrences = this.itemDoneCalls.get(scope).get(seqField).get(arg);
                    for (HidOccurrence occ : occurrences) {
                        if (this.hasGetNextItemCallBefore(scope, seqField, arg, occ)) continue;
                        this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(seqField), LintUtils.getNamedElementFullName(scope)));
                    }
                }
            }
        }
    }

    private boolean hasGetNextItemCallBefore(RfNamedElement scope, RfField field, IHid arg, HidOccurrence occ) {
        Set<HidOccurrence> occurrences = this.getNextItemCalls.get(scope).get(field).get(arg);
        for (HidOccurrence getNextItemOcc : occurrences) {
            if (getNextItemOcc.getOffset() >= occ.getOffset()) continue;
            return true;
        }
        return false;
    }

    private void addHits(RfNamedElement scope) {
        Map<RfField, Map<IHid, Set<HidOccurrence>>> map = this.itemDoneCalls.get(scope);
        Set<RfField> fieldSet = map.keySet();
        for (RfField field : fieldSet) {
            Map<IHid, Set<HidOccurrence>> map2 = map.get(field);
            Set<IHid> hidSet = map2.keySet();
            for (IHid hid : hidSet) {
                Set<HidOccurrence> occSet = map2.get(hid);
                for (HidOccurrence occ : occSet) {
                    this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(field), LintUtils.getNamedElementFullName(scope)));
                }
            }
        }
    }

    private void addHits(RfNamedElement scope, RfField field) {
        Map<IHid, Set<HidOccurrence>> map = this.itemDoneCalls.get(scope).get(field);
        Set<IHid> hidSet = map.keySet();
        for (IHid hid : hidSet) {
            Set<HidOccurrence> occSet = map.get(hid);
            for (HidOccurrence occ : occSet) {
                this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(field), LintUtils.getNamedElementFullName(scope)));
            }
        }
    }

    private void addHits(RfNamedElement scope, RfField field, IHid arg) {
        Set<HidOccurrence> occSet = this.itemDoneCalls.get(scope).get(field).get(arg);
        for (HidOccurrence occ : occSet) {
            this.addHit(scope.getDeclaration().getParserPath(), occ, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(field), LintUtils.getNamedElementFullName(scope)));
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.getNextItemCalls != null) {
            this.getNextItemCalls.clear();
        }
        if (this.itemDoneCalls != null) {
            this.itemDoneCalls.clear();
        }
    }
}

