/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1114")
@CheckName(value="R.1114")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.COMPILATION, RuleLabel.SHADOWING})
@CheckTitle(value="Do not compile types with the same name in different libraries")
@CheckDescription(value="Types must have an unique name across different libraries.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1114
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="package, class, typealias", description="Comma separated list of element kinds which will be checked: package, class, typealias, global_class, global_typealias, package_class, package_typealias.", name="elementKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKinds;
    @CheckParameter(defaultValue="", description="Comma separated list of packages which will be skipped.", name="skipPackages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipPackages;
    private Map<RfLibrary, Map<Class<? extends IRfNamedElement>, Map<String, Set<RfNamedElement>>>> typesWithNameAndLibrary = new LinkedHashMap<RfLibrary, Map<Class<? extends IRfNamedElement>, Map<String, Set<RfNamedElement>>>>();
    private Set<RfLibrary> visitedLibraries = new HashSet<RfLibrary>();
    private Set<String> visitedNames = new HashSet<String>();
    private Set<Class<? extends IRfNamedElement>> types = new HashSet<Class<? extends IRfNamedElement>>();

    public Check_R_1114(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Collection<RfLibrary> libraries;
        this.cleanTypesWithNameAndLibrary();
        this.visitedLibraries.clear();
        this.visitedNames.clear();
        this.types.clear();
        if (this.pElementKinds.contains("package")) {
            this.types.add(RfPackage.class);
        }
        if (this.pElementKinds.contains("class") || this.pElementKinds.contains("global_class") || this.pElementKinds.contains("package_class")) {
            this.types.add(RfClass.class);
        }
        if (this.pElementKinds.contains("typealias") || this.pElementKinds.contains("global_typealias") || this.pElementKinds.contains("package_typealias")) {
            this.types.add(RfTypeAlias.class);
        }
        if ((libraries = this.fOVMProject.getRfProject().getAllLibraries()) == null || libraries.isEmpty() || libraries.size() == 1) {
            return;
        }
        for (RfLibrary library : libraries) {
            if (library == null) continue;
            try {
                library.visitNamedElements(this.fOVMProject.getRfProject(), namedElement -> {
                    String packageName;
                    if (namedElement.isPredefined()) {
                        return true;
                    }
                    Class<?> namedElementType = namedElement.getClass();
                    if (!this.types.contains(namedElementType)) {
                        return true;
                    }
                    RfFileDef fileDef = namedElement.getFile();
                    if (fileDef != null && this.pathIsPrewaived(fileDef.getParserPath())) {
                        return true;
                    }
                    RfPackage enclosingPackage = namedElement.getEnclosingPackage();
                    if ((this.pElementKinds.contains("global_class") || this.pElementKinds.contains("global_typealias")) && enclosingPackage != null && !(namedElement instanceof RfPackage)) {
                        return true;
                    }
                    if ((this.pElementKinds.contains("package_class") || this.pElementKinds.contains("package_typealias")) && enclosingPackage == null) {
                        return true;
                    }
                    if (enclosingPackage != null && (packageName = enclosingPackage.getName()) != null && this.pSkipPackages.contains(packageName)) {
                        return true;
                    }
                    String name = namedElement.getName();
                    if (!this.typesWithNameAndLibrary.containsKey(library)) {
                        this.typesWithNameAndLibrary.put(library, new LinkedHashMap());
                    }
                    if (!this.typesWithNameAndLibrary.get(library).containsKey(namedElementType)) {
                        this.typesWithNameAndLibrary.get(library).put(namedElementType, new LinkedHashMap());
                    }
                    if (!this.typesWithNameAndLibrary.get(library).get(namedElementType).containsKey(name)) {
                        this.typesWithNameAndLibrary.get(library).get(namedElementType).put(name, new HashSet());
                    }
                    this.typesWithNameAndLibrary.get(library).get(namedElementType).get(name).add(namedElement);
                    this.notifyCheckAlive();
                    return true;
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        Set<RfLibrary> resolvedLibraries = this.typesWithNameAndLibrary.keySet();
        if (resolvedLibraries == null || resolvedLibraries.isEmpty() || resolvedLibraries.size() == 1) {
            return;
        }
        for (RfLibrary currentLibrary : resolvedLibraries) {
            this.visitedLibraries.add(currentLibrary);
            Set<Class<? extends IRfNamedElement>> typesInCurrentLibrary = this.typesWithNameAndLibrary.get(currentLibrary).keySet();
            for (Class<? extends IRfNamedElement> type : typesInCurrentLibrary) {
                this.notifyCheckAlive();
                Set<String> names = this.typesWithNameAndLibrary.get(currentLibrary).get(type).keySet();
                for (String name : names) {
                    if (this.visitedNames.contains(name)) continue;
                    HashSet<RfNamedElement> hitElements = new HashSet<RfNamedElement>();
                    for (RfLibrary library : resolvedLibraries) {
                        if (this.visitedLibraries.contains(library) || !this.typesWithNameAndLibrary.get(library).containsKey(type) || !this.typesWithNameAndLibrary.get(library).get(type).containsKey(name)) continue;
                        hitElements.addAll((Collection<RfNamedElement>)this.typesWithNameAndLibrary.get(library).get(type).get(name));
                    }
                    if (hitElements.isEmpty()) continue;
                    this.addLocalHit(this.typesWithNameAndLibrary.get(currentLibrary).get(type).get(name).iterator().next(), hitElements);
                    this.visitedNames.add(name);
                }
            }
        }
    }

    private void addLocalHit(RfNamedElement hitElement, Set<RfNamedElement> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        this.addHit(hitElement, this.getFailMessage(hitElement, elements));
    }

    private String getFailMessage(RfNamedElement firstElement, Set<RfNamedElement> elements) {
        StringBuilder messageSb = new StringBuilder("Duplicate identifier names from different libraries:\n ");
        messageSb.append(this.addLineFileInfo(firstElement, String.valueOf(LintUtils.getElementKind(firstElement)) + " '" + LintUtils.getNamedElementFullName(firstElement) + "' from library '" + firstElement.getEnclosingLibrary() + "' - "));
        for (RfNamedElement element : elements) {
            RfFileDef file = element.getFile();
            if (file == null) continue;
            messageSb.append(this.addLineFileInfo(element, "\n " + LintUtils.getElementKind(element) + " '" + LintUtils.getNamedElementFullName(element) + "' from library '" + element.getEnclosingLibrary() + "' - "));
        }
        return messageSb.toString();
    }

    private boolean pathIsPrewaived(ParserPath path) {
        return path != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private void cleanTypesWithNameAndLibrary() {
        if (this.typesWithNameAndLibrary == null) {
            return;
        }
        Set<RfLibrary> libraries = this.typesWithNameAndLibrary.keySet();
        for (RfLibrary library : libraries) {
            Map<Class<? extends IRfNamedElement>, Map<String, Set<RfNamedElement>>> map;
            if (library == null || (map = this.typesWithNameAndLibrary.get(library)) == null || map.isEmpty()) continue;
            for (Class<? extends IRfNamedElement> type : map.keySet()) {
                if (type == null) continue;
                Set<String> names = this.typesWithNameAndLibrary.get(library).get(type).keySet();
                for (String name : names) {
                    if (name == null) continue;
                    this.typesWithNameAndLibrary.get(library).get(type).get(name).clear();
                }
                this.typesWithNameAndLibrary.get(library).get(type).clear();
            }
            this.typesWithNameAndLibrary.get(library).clear();
        }
        this.typesWithNameAndLibrary.clear();
    }

    @Override
    public void clean() {
        super.clean();
        this.cleanTypesWithNameAndLibrary();
        if (this.visitedLibraries != null) {
            this.visitedLibraries.clear();
        }
        if (this.visitedNames != null) {
            this.visitedNames.clear();
        }
        if (this.types != null) {
            this.types.clear();
        }
    }
}

