/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractRaiseAndDropObjectionCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="21.1.51")
@CheckID(value="R.1115")
@CheckName(value="R.1115")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.OBJECTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Dropped objections must be raised")
@CheckDescription(value="This rule flags methods that drop an objection which is not raised.\n\nExample:\ntask run_phase(uvm_phase phase);\n  phase.raise_objection(this);\n  begin\n    my_sequence seq;\n    seq = my_sequence::type_id::create(\"seq\");\n    seq.start(sequencer);\n  end\n  phase.drop_objection(this);  //allowed\nendtask\n\ntask run_phase(uvm_phase phase);\n  begin\n    my_sequence seq;\n    seq = my_sequence::type_id::create(\"seq\");\n    seq.start(sequencer);\n  end\n  phase.drop_objection(this);  //not allowed\nendtask")
public class Check_R_1115
extends AbstractRaiseAndDropObjectionCheck {
    public Check_R_1115(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    void checkRaiseAndDropCalls(List<AbstractRaiseAndDropObjectionCheck.ObjectionInfo> raiseArguments, List<AbstractRaiseAndDropObjectionCheck.ObjectionInfo> dropArguments, ParserPath classParserPath, RfFunction function) {
        for (AbstractRaiseAndDropObjectionCheck.ObjectionInfo dropObjectionInfo : dropArguments) {
            RfHid dropHid = dropObjectionInfo.getObjectionCall();
            RfHid dropArg = dropObjectionInfo.getObjectionParam();
            AbstractRaiseAndDropObjectionCheck.ObjectionInfo associatedRaiseObjectionInfo = null;
            for (AbstractRaiseAndDropObjectionCheck.ObjectionInfo raiseObjectionInfo : raiseArguments) {
                RfHid raiseArg;
                RfHid raiseHid = raiseObjectionInfo.getObjectionCall();
                if (!this.checkCorrespondingHid(raiseHid, raiseArg = raiseObjectionInfo.getObjectionParam(), dropHid, dropArg)) continue;
                associatedRaiseObjectionInfo = raiseObjectionInfo;
                break;
            }
            if (associatedRaiseObjectionInfo == null) {
                this.addHit(classParserPath, dropHid.getOccurrence(), "Dropped objection was not raised for object: '" + dropArg.getName() + "' in method: '" + LintUtils.getNamedElementFullName(function) + "'!");
                continue;
            }
            raiseArguments.remove(associatedRaiseObjectionInfo);
        }
    }
}

