/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="21.1.52")
@CheckID(value="R.1116")
@CheckName(value="R.1116")
@CheckLabel(labels={RuleLabel.ENUM, RuleLabel.RANDOMIZATION, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare fields of enum type as rand or randc")
@CheckDescription(value="The check flags class fields of enum type that are declared rand or randc.\n\nCheck supports pre-waiving.")
public class Check_R_1116
extends OVMComplianceCheck {
    public Check_R_1116(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            List<RfField> fields;
            this.notifyCheckAlive();
            if (clazz == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this) || (fields = clazz.getFields()) == null || fields.isEmpty()) continue;
            for (RfField field : fields) {
                RfNamedElement finalType = LintUtils.getAssociatedFinalType(field);
                if (finalType == null || finalType.getName() == null || !(finalType instanceof RfStruct) || !((RfStruct)finalType).isEnum()) continue;
                if (field.isRand()) {
                    this.addHit(field, "Field '" + LintUtils.getNamedElementFullName(field) + "' of enum type is declared as rand!");
                    continue;
                }
                if (!field.isRandc()) continue;
                this.addHit(field, "Field '" + LintUtils.getNamedElementFullName(field) + "' of enum type is declared as randc!");
            }
        }
    }
}

