/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.52")
@CheckID(value="R.1117")
@CheckName(value="R.1117")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.OBJECTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Objections must be raised and dropped")
@CheckDescription(value="The rule flags if there is no raised or dropped objection in the project.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1117
extends OVMComplianceCheck {
    private static final String RAISE_OBJECTION = "raise_objection";
    private static final String DROP_OBJECTION = "drop_objection";
    private static final String PHASE_RAISE_OBJECTION = "_phase.raise_objection";
    private static final String OBJECTION_RAISE_OBJECTION = "_objection.raise_objection";
    private static final String TEST_DONE_RAISE_OBJECTION = "_test_done_objection.raise_objection";
    private static final String PHASE_DROP_OBJECTION = "_phase.drop_objection";
    private static final String OBJECTION_DROP_OBJECTION = "_objection.drop_objection";
    private static final String TEST_DONE_DROP_OBJECTION = "_test_done_objection.drop_objection";
    private Set<String> objectionRelatedMethodsFullName;

    public Check_R_1117(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        int kind = this.fOVMProject.getLibraryKind();
        String libraryPkg = OVMUtils.prependLibraryPrefixTo(kind, "_pkg::");
        this.objectionRelatedMethodsFullName = new HashSet<String>();
        if (kind == 2) {
            this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, PHASE_RAISE_OBJECTION));
            this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, PHASE_DROP_OBJECTION));
        }
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, OBJECTION_RAISE_OBJECTION));
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, OBJECTION_DROP_OBJECTION));
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, TEST_DONE_RAISE_OBJECTION));
        this.objectionRelatedMethodsFullName.add(String.valueOf(libraryPkg) + OVMUtils.prependLibraryPrefixTo(kind, TEST_DONE_DROP_OBJECTION));
    }

    @Override
    public void performCheckImpl() {
        LocalHidVisitor visitor = new LocalHidVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        if (!visitor.foundRaisedOrDroppedObjection) {
            this.addHit(new ParserPath("none"), 0, "No objection is raised or dropped in project!", null);
        }
    }

    private boolean pathIsPrewaived(ParserPath path) {
        return path != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private boolean checkMethodIsObjectionRelated(RfHid hid) {
        IRfNamedElement hidNamedElement = hid.getElement();
        if (!(hidNamedElement instanceof RfFunction)) {
            return false;
        }
        RfFunction localFunctionCall = (RfFunction)hidNamedElement;
        String functionName = localFunctionCall.getName();
        if (functionName == null) {
            return false;
        }
        if (!RAISE_OBJECTION.equals(functionName) && !DROP_OBJECTION.equals(functionName)) {
            return false;
        }
        String fullName = LintUtils.getNamedElementFullName(localFunctionCall);
        return fullName != null && this.objectionRelatedMethodsFullName.contains(fullName);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        private boolean foundRaisedOrDroppedObjection = false;

        public boolean visit(RfHid hidObject) {
            if (Check_R_1117.this.pathIsPrewaived(this.parserPath)) {
                return true;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            Check_R_1117.this.notifyCheckAlive();
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            if (!(holderScope instanceof RfNamedElement)) {
                return true;
            }
            RfPackage enclosingPackage = (RfPackage)holderScope.getEnclosingScope(RfPackage.class);
            if (enclosingPackage != null && Check_R_1117.this.fOVMProject.isOVMElement(enclosingPackage)) {
                return true;
            }
            if (!Check_R_1117.this.checkMethodIsObjectionRelated(hidObject)) {
                return true;
            }
            this.foundRaisedOrDroppedObjection = true;
            return false;
        }

        boolean getFoundRaisedOrDroppedObjection() {
            return this.foundRaisedOrDroppedObjection;
        }
    }
}

