/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="22.1.1")
@CheckID(value="R.1118")
@CheckName(value="R.1118")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.IMPORT, RuleLabel.PARAMETER, RuleLabel.PORT})
@CheckTitle(value="Import declarations in modules must be before parameters and port lists")
@CheckDescription(value="This rule flags any import that is not declared before parameters and port lists inside a non-ANSI module.\n\nExample:\n\nmodule m1 (input_port, output_port);\n  import package_0::*; // allowed\n  input input_port;\n  output output_port;\n  parameter size = 8;\n  import package_1::*; // not allowed\nendmodule\n\n\nCheck supports pre-waiving.")
public class Check_R_1118
extends OVMComplianceCheck {
    public Check_R_1118(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        IRfNamedElementVisitor neVisitor = namedElement -> {
            List<RfField> parameters;
            if (namedElement == null) {
                return true;
            }
            if (!(namedElement instanceof RfModule)) {
                return true;
            }
            RfModule module = (RfModule)namedElement;
            if (!module.isNonAnsi()) {
                return true;
            }
            this.notifyCheckAlive();
            RfFileDef file = namedElement.getFile();
            if (file == null) {
                return true;
            }
            ParserPath moduleParserPath = file.getParserPath();
            if (this.checkPreWaivers(moduleParserPath)) {
                return true;
            }
            NullProtectedList<ImportInfo> allImportDeclarations = namedElement.getAllImportDeclarations();
            if (allImportDeclarations == null || allImportDeclarations.isEmpty()) {
                return true;
            }
            ArrayList elementsToBeChecked = new ArrayList();
            List<IRfPortElement> ports = module.getLocalPorts();
            if (ports != null && !ports.isEmpty()) {
                elementsToBeChecked.addAll(ports.stream().flatMap(port -> port.getDeclarations().stream()).filter(portDef -> !(portDef instanceof RfPortDef) || !((RfPortDef)portDef).isInListOfPorts()).map(portDef -> new ModuleFieldInfo(FieldType.PORT, portDef.getName(), portDef.getStartOffset(), portDef.getStartLine(), portDef.getParserPath())).collect(Collectors.toList()));
            }
            if ((parameters = module.getLocalParameters()) != null && !parameters.isEmpty()) {
                elementsToBeChecked.addAll(parameters.stream().filter(param -> !(param instanceof RfField) || !((RfField)param).isInParameterPortList()).flatMap(param -> param.getDeclarations().stream()).map(paramDef -> new ModuleFieldInfo(FieldType.PARAMETER, paramDef.getName(), paramDef.getStartOffset(), paramDef.getStartLine(), paramDef.getParserPath())).collect(Collectors.toList()));
            }
            if (elementsToBeChecked.isEmpty()) {
                return true;
            }
            block0: for (ImportInfo importInfo : allImportDeclarations) {
                for (ModuleFieldInfo element : elementsToBeChecked) {
                    if (!this.isHit(importInfo, element, module)) continue;
                    this.addHit(importInfo.getParserPath(), importInfo.getLine(), this.getHitMessage(module, importInfo, element), null);
                    continue block0;
                }
            }
            return true;
        };
        rfProject.accept(neVisitor);
    }

    private String getHitMessage(RfModule module, ImportInfo importInfo, ModuleFieldInfo element) {
        StringBuilder hitMessage = new StringBuilder();
        hitMessage.append("Import '").append(importInfo.getPackageName()).append("' inside module '").append(module.getName()).append("' is declared after ").append((Object)element.getType()).append(" '").append(element.getName()).append("' ").append(this.link("defined at line " + element.getLine() + " in file '" + element.getParserPath() + "'", element.getParserPath().toString(), element.getLine())).append("!");
        return hitMessage.toString();
    }

    public boolean isHit(ImportInfo importInfo, ModuleFieldInfo element, RfModule module) {
        ParserPath elementPath;
        ParserPath importPath = importInfo.getParserPath();
        if (importPath.equals((Object)(elementPath = element.getParserPath()))) {
            return importInfo.getOffset() > element.getOffset();
        }
        return this.isHitWithIncludes(importInfo, element, module, importPath, elementPath);
    }

    private boolean isHitWithIncludes(ImportInfo importInfo, ModuleFieldInfo element, RfModule module, ParserPath importPath, ParserPath elementPath) {
        ParserPath moduleParserPath = module.getFile().getParserPath();
        int startLine = module.getLine();
        int endLine = module.getEndLine();
        Map includedFilesMap = this.fOVMProject.getAllFilesWithIncludes().get(moduleParserPath);
        if (includedFilesMap == null || includedFilesMap.isEmpty()) {
            return false;
        }
        List includeFileWithImportLine = (List)includedFilesMap.get(importPath);
        List includeFileWithElementLine = (List)includedFilesMap.get(elementPath);
        boolean samePathModuleAndImport = moduleParserPath.equals((Object)importPath);
        boolean samePathModuleAndElement = moduleParserPath.equals((Object)elementPath);
        if (!samePathModuleAndElement && !samePathModuleAndImport) {
            if (includeFileWithElementLine == null || includeFileWithImportLine == null) {
                return false;
            }
            for (Integer importLine : includeFileWithImportLine) {
                for (Integer elementLine : includeFileWithElementLine) {
                    if (endLine < importLine || importLine < startLine || endLine < elementLine || elementLine < startLine || importLine <= elementLine) continue;
                    return true;
                }
            }
            return false;
        }
        if (samePathModuleAndElement && !samePathModuleAndImport) {
            if (includeFileWithImportLine == null) {
                return false;
            }
            for (Integer importLine : includeFileWithImportLine) {
                if (endLine < importLine || importLine < startLine || importLine <= element.getLine()) continue;
                return true;
            }
            return false;
        }
        if (!samePathModuleAndElement && samePathModuleAndImport) {
            if (includeFileWithElementLine == null) {
                return false;
            }
            for (Integer elementLine : includeFileWithElementLine) {
                if (endLine < elementLine || elementLine < startLine || importInfo.getLine() <= elementLine) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static enum FieldType {
        PARAMETER,
        PORT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static class ModuleFieldInfo {
        private FieldType type;
        private int offset;
        private int line;
        private String name;
        private ParserPath path;

        public ModuleFieldInfo(FieldType type, String name, int offset, int line, ParserPath path) {
            this.type = type;
            this.offset = offset;
            this.line = line;
            this.name = name;
            this.path = path;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }

        public String getName() {
            return this.name;
        }

        public ParserPath getParserPath() {
            return this.path;
        }

        public FieldType getType() {
            return this.type;
        }
    }
}

