/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedVirtualInterface;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfNonStandardField;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="21.1.53")
@CheckID(value="R.1119")
@CheckName(value="R.1119")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.INTERFACE, RuleLabel.DESIGN_INSTANTIATION})
@CheckTitle(value="All interfaces should be instantiated")
@CheckDescription(value="Creating an interface without instantiating it is not allowed.\n\nCheck supports pre-waiving.")
public class Check_R_1119
extends OVMComplianceCheck {
    public Check_R_1119(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> unusedInterfaces = new NullProtectedList<RfNamedElement>((Collection<RfNamedElement>)this.fOVMProject.getAllInterfaces());
        this.fOVMProject.getRfProject().accept(namedElement -> {
            RfDefElement declaration = namedElement.getDeclaration();
            if (declaration != null && this.checkPrewaivers(declaration.getParserPath())) {
                return true;
            }
            this.notifyCheckAlive();
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            if (namedElement instanceof RfNonStandardField) {
                return true;
            }
            RfField fieldElement = (RfField)namedElement;
            RfNamedElement fieldType = LintUtils.getAssociatedFinalType(fieldElement, RfTypesResolver.create((IRfScopeElement)fieldElement.getEnclosingScope(), fieldElement.getEnclosingScope().getRfProject(), 30));
            if (!(fieldType instanceof RfInterface)) {
                return true;
            }
            RfInterface interfaceElement = (RfInterface)fieldType;
            if (interfaceElement instanceof RfSpecializedVirtualInterface) {
                interfaceElement = ((RfSpecializedVirtualInterface)interfaceElement).getGenericElement();
            }
            unusedInterfaces.remove(interfaceElement);
            return true;
        });
        for (RfNamedElement unusedInterface : unusedInterfaces) {
            RfDefElement declaration = unusedInterface.getDeclaration();
            if (declaration != null && this.checkPrewaivers(declaration.getParserPath())) continue;
            this.addHit(unusedInterface, "The '" + unusedInterface.getName() + "' interface is not instantiated!");
        }
        unusedInterfaces.clear();
    }

    private boolean checkPrewaivers(ParserPath path) {
        return path != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

