/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.3")
@CheckID(value="R.1120")
@CheckName(value="R.1120")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERGROUP, RuleLabel.COVERPOINT, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Variables used in conditional coverpoints or bins should be covergroup arguments")
@CheckDescription(value="This check flags variables used in conditional coverpoints or bins that are not covergroup arguments.\nHaving such variables passed as arguments allows for a more robust control on the coverage report.\n\nExamples:\nint bad_variable;\ncovergroup cg0(good_variable);\n  vec : coverpoint sample_vec {\n     bins h1 = { 4'b0001 } iff (bad_variable == 0); // not allowed\n     bins h2 = { 4'b0010 } iff (good_variable == 0); // allowed\n  }\nendgroup\n\nCheck supports pre-waiving.")
public class Check_R_1120
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, sample method arguments are allowed.", name="allowSampleArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowSampleArguments;

    public Check_R_1120(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        CoverpointVisitor visitor = new CoverpointVisitor();
        for (RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            Map<RfField, List<HidOccurrence>> variables;
            List<RfCoverpoint> coverpoints;
            ParserPath parserPath;
            if (covergroup.getFile() == null || this.checkPrewaivers(parserPath = covergroup.getFile().getParserPath()) || (coverpoints = covergroup.getLocalMembers(RfCoverpoint.class)) == null || coverpoints.isEmpty() || (variables = this.getVariablesUsagesInCover(visitor, coverpoints)) == null || variables.isEmpty()) continue;
            List<RfField> covergroupParameters = covergroup.getLocalMembers(RfField.class);
            if (covergroupParameters != null) {
                variables.entrySet().removeIf(entry -> entry.getKey() != null && covergroupParameters.contains(entry.getKey()));
            }
            for (Map.Entry<RfField, List<HidOccurrence>> entry2 : variables.entrySet()) {
                RfField field = entry2.getKey();
                List<HidOccurrence> occurrences = entry2.getValue();
                if (field == null || occurrences == null) continue;
                for (HidOccurrence occurrence : occurrences) {
                    this.addHit(parserPath, occurrence, "Variable '" + field.getName() + "' should be a covergroup argument!", null);
                }
            }
        }
    }

    private Map<RfField, List<HidOccurrence>> getVariablesUsagesInCover(CoverpointVisitor visitor, List<RfCoverpoint> coverpoints) {
        visitor.clean();
        for (RfCoverpoint coverpoint : coverpoints) {
            coverpoint.visitHidObject(null, visitor);
        }
        return visitor.getElements();
    }

    private boolean checkPrewaivers(ParserPath path) {
        return path != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private class CoverpointVisitor
    implements IHidVisitor<IHidObject> {
        private Map<RfField, List<HidOccurrence>> elements = new HashMap<RfField, List<HidOccurrence>>();

        public boolean visit(IHidObject hidObject) {
            if (hidObject instanceof RfHid) {
                return this.visitHid((RfHid)hidObject);
            }
            if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isCoverpointExpression()) {
                hidObject = ((RfHidOperator)hidObject).getLHValue();
            }
            if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isIffExpression()) {
                Set hids = ((RfHidOperator)hidObject).getRHHids(HidFlatteningOption.RANGE_CONSTANT_HIDS);
                for (IHid hid : hids) {
                    this.visitHid((RfHid)hid);
                }
            }
            return true;
        }

        private boolean visitHid(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (hid.getReparseInfo() != null) {
                return true;
            }
            if (hid.isMethodCall(false)) {
                this.checkArguments(hid);
            }
            if (hid.getParentAccess() != null) {
                this.visitHid((RfHid)hid.getParentHid());
                return true;
            }
            if (hid.hasQualifier(HidQualifierCache.IS_IN_COVERGROUP_EXPRESSION)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            if (field instanceof RfCoverpoint) {
                return true;
            }
            if (field.isPredefined()) {
                return true;
            }
            if (field.isParameter()) {
                return true;
            }
            if (field.isEnumElement()) {
                return true;
            }
            if (field.isArgument() && field.getEnclosingScope() instanceof RfFunction && (!field.getEnclosingScope().getName().equals("sample") || Check_R_1120.this.pAllowSampleArguments)) {
                return true;
            }
            if (this.elements.get(field) == null) {
                this.elements.put(field, new ArrayList());
            }
            this.elements.get(field).add(hid.getOccurrence());
            return true;
        }

        private void checkArguments(RfHid hid) {
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    Set argumentHids = HidUtils.flattenToHids((IHidObject)((IHidObject)entry.getValue()), (Set)HidFlatteningOption.RANGE_CONSTANT_HIDS);
                    for (IHid argumentHid : argumentHids) {
                        if (!(argumentHid instanceof RfHid)) continue;
                        this.visitHid((RfHid)argumentHid);
                    }
                }
            }
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public Map<RfField, List<HidOccurrence>> getElements() {
            return this.elements;
        }

        public void clean() {
            this.elements.clear();
        }
    }
}

