/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="22.1.1")
@CheckID(value="R.1121")
@CheckName(value="R.1121")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.RANDOMIZATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Call set_item_context before randomizing a sequence")
@CheckDescription(value="In order to ensure the UVM seeding for sequences, always call set_item_context before randomizing a sequence.\nThis rule only checks if set_item_context is called before randomize in the same method scope.\n\nExamples:\ntask run_phase(uvm_phase phase);\n  uvm_sequence my_seq;\n  my_seq.randomize();  //not allowed\nendtask : run_phase\n\ntask run_phase(uvm_phase phase);\n  uvm_sequence my_seq;\n  my_seq.set_item_context(...);\n  my_seq.randomize();  //allowed\nendtask : run_phase\n\nCheck supports pre-waiving.")
public class Check_R_1121
extends OVMComplianceCheck {
    private Map<RfFunction, Map<RfField, HidOccurrence>> setItemContextCalls = new HashMap<RfFunction, Map<RfField, HidOccurrence>>();
    private static final String SET_ITEM_CONTEXT = "set_item_context";
    private static final String RANDOMIZE = "randomize";
    private static final String HIT_MESSAGE_FORMAT = "Missing the set_item_context() call before the randomize() call on sequence ''{0}'' in ''{1}''!";

    public Check_R_1121(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.setItemContextCalls.clear();
        if (this.fOVMProject.getLibraryKind() == 1) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new SetItemContextCallsVisitor());
        this.fOVMProject.getRfProject().visitHidObject(null, new RandomizeCallsVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.setItemContextCalls != null) {
            this.setItemContextCalls.clear();
        }
    }

    class RandomizeCallsVisitor
    extends RfHidVisitor {
        private RfNamedElement scope;

        RandomizeCallsVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (this.scope.isPredefined()) {
                return true;
            }
            if (Check_R_1121.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                return true;
            }
            if (Check_R_1121.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1121.this.notifyCheckAlive();
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (!function.getName().equals(Check_R_1121.RANDOMIZE)) {
                return true;
            }
            HidAccess parentAccess = hidObject.getParentAccess();
            if (parentAccess == null) {
                return true;
            }
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (!(associatedType instanceof RfClass)) {
                return true;
            }
            if (!LintUtils.isSubClassOf((RfClass)associatedType, ((Check_R_1121)Check_R_1121.this).fOVMProject.fOvmSequence)) {
                return true;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement sequenceElement = parentHid.getElement();
            if (!(sequenceElement instanceof RfField)) {
                return true;
            }
            RfField sequenceField = (RfField)sequenceElement;
            RfFunction functionScope = this.scope.getEnclosingScope(RfFunction.class);
            if (functionScope == null) {
                return true;
            }
            if (!this.hasSetItemContextBefore(functionScope, sequenceField, hidObject.getOccurrence())) {
                Check_R_1121.this.addHit(this.parserPath, hidObject, MessageFormat.format(Check_R_1121.HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(sequenceField), LintUtils.getNamedElementFullName(functionScope)));
            }
            return true;
        }

        private boolean hasSetItemContextBefore(RfFunction functionScope, RfField sequence, HidOccurrence randomizeOcc) {
            if (!Check_R_1121.this.setItemContextCalls.containsKey(functionScope)) {
                return false;
            }
            Map<RfField, HidOccurrence> sequenceWithFirstCall = Check_R_1121.this.setItemContextCalls.get(functionScope);
            if (!sequenceWithFirstCall.containsKey(sequence)) {
                return false;
            }
            HidOccurrence firstOcc = sequenceWithFirstCall.get(sequence);
            if (firstOcc.getOffset() < randomizeOcc.getOffset()) {
                return true;
            }
            return firstOcc.getOffset() == randomizeOcc.getOffset() && firstOcc.getVirtualOffset() < randomizeOcc.getVirtualOffset();
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }

    class SetItemContextCallsVisitor
    extends RfHidVisitor {
        private RfNamedElement scope;

        SetItemContextCallsVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (this.scope.isPredefined()) {
                return true;
            }
            if (Check_R_1121.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                return true;
            }
            if (Check_R_1121.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1121.this.notifyCheckAlive();
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (!function.getName().equals(Check_R_1121.SET_ITEM_CONTEXT)) {
                return true;
            }
            HidAccess parentAccess = hidObject.getParentAccess();
            if (parentAccess == null) {
                return true;
            }
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (!(associatedType instanceof RfClass)) {
                return true;
            }
            if (!LintUtils.isSubClassOf((RfClass)associatedType, ((Check_R_1121)Check_R_1121.this).fOVMProject.fOvmSequence)) {
                return true;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement sequenceElement = parentHid.getElement();
            if (!(sequenceElement instanceof RfField)) {
                return true;
            }
            RfFunction functionScope = this.scope.getEnclosingScope(RfFunction.class);
            if (functionScope == null) {
                return true;
            }
            Map<RfField, HidOccurrence> calls = Check_R_1121.this.setItemContextCalls.get(functionScope);
            if (calls == null) {
                calls = new HashMap<RfField, HidOccurrence>();
            }
            if (calls.containsKey(sequenceElement)) {
                return true;
            }
            calls.put((RfField)sequenceElement, hidObject.getOccurrence());
            Check_R_1121.this.setItemContextCalls.put(functionScope, calls);
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

