/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="22.1.1")
@CheckID(value="R.1122")
@CheckName(value="R.1122")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.MACRO, RuleLabel.ASSIGNMENT, RuleLabel.AMS, RuleLabel.DESIGN})
@CheckTitle(value="Do not assign `wrealXState and `wrealZState to logic or reg variables")
@CheckDescription(value="Using the `wrealXState and `wrealZState macro calls as assingment for a reg or logic variable is not allowed.\nThis rule checks simple assignments, method calls for logic or reg arguments and port connections as well.\n\nExample:\nlogic lg;\nint var;\nlg = `wrealXState // not allwoed\nvar = `wrealXState // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1122
extends OVMComplianceCheck {
    private static final String LOGIC = "logic";
    private static final String REG = "reg";
    private final HidOperatorVisitor assignmentsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidObject) {
            if (Check_R_1122.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (hidObject.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) || hidObject.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                this.checkOperator(hidObject, "assignment");
                return true;
            }
            if (hidObject.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER)) {
                this.checkOperator(hidObject, "method argument");
                return true;
            }
            if (hidObject.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION)) {
                this.checkOperator(hidObject, "port connection");
                return true;
            }
            return true;
        }

        private void checkOperator(HidOperator hidObject, String operatorType) {
            Check_R_1122.this.notifyCheckAlive();
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return;
            }
            IHidObject rhValueHid = (IHidObject)rhValues.get(0);
            if (!(rhValueHid instanceof RfHidImplicit)) {
                return;
            }
            RfHidImplicit rhHidImplicit = (RfHidImplicit)rhValueHid;
            if (!"0".equals(rhHidImplicit.getName())) {
                return;
            }
            IReparseElement ireparseElement = rhHidImplicit.getLastReparseElement();
            if (!(ireparseElement instanceof ReparseInfo.ReparseElement)) {
                return;
            }
            ReparseInfo.ReparseElement reparseElement = (ReparseInfo.ReparseElement)ireparseElement;
            if (!"wrealXState".equals(reparseElement.getReparseMacroName()) && !"wrealZState".equals(reparseElement.getReparseMacroName())) {
                return;
            }
            IHidObject lhValue = hidObject.getLHValue();
            IRfNamedElement lhType = null;
            if (lhValue instanceof RfHidAccessArgs) {
                lhValue = ((RfHidAccessArgs)lhValue).getParentHid();
            }
            if (lhValue instanceof RfHidAccess) {
                lhType = ((RfHidAccess)lhValue).getAssociatedType();
            } else if (lhValue instanceof RfHid) {
                IRfNamedElement rhElement = ((IHid)lhValue).getElement();
                if (!(rhElement instanceof RfAssociatedType)) {
                    return;
                }
                lhType = ((RfAssociatedType)rhElement).getAssociatedType();
            }
            if (hidObject.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                ISDataAbstract resolvedType = hidObject.getOperatorResolvedType();
                if (resolvedType == null) {
                    return;
                }
                ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
                if (dataType == null) {
                    return;
                }
                IRfNamedElement iRfNamedElement = lhType = SDataUtils.getUndefinedDataType((ISDataAbstract)dataType) == null ? dataType.getType() : null;
            }
            if (lhType == null) {
                return;
            }
            if (!Check_R_1122.LOGIC.equals(lhType.getName()) && !Check_R_1122.REG.equals(lhType.getName())) {
                return;
            }
            Check_R_1122.this.addHit(this.parserPath, hidObject.getOccurrence().getLine(), "Illegal usage of `" + reparseElement.getReparseMacroName() + " macro for " + operatorType + "!", null);
        }
    };

    public Check_R_1122(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.assignmentsVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

