/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.1")
@CheckID(value="R.1123")
@CheckName(value="R.1123")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.DELAY, RuleLabel.LOOP, RuleLabel.WHILE, RuleLabel.EDGE})
@CheckTitle(value="Do not use edge delays or #delay in while loops")
@CheckDescription(value="Do not add delay inside while loops using delay or event control, use wait statements instead.\n\nExamples:\nwhile (...) begin\n  @(posedge signal);  //not allowed\nend\nwait (signal);  //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1123
extends OVMComplianceCheck {
    public Check_R_1123(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> allActionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : allActionBlocks) {
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(actionBlock.getDeclaration().getParserPath(), this) || !actionBlock.isWhile() && !actionBlock.isDoWhile()) continue;
            actionBlock.visitHidObject(null, new ActionBlockVisitor());
        }
    }

    class ActionBlockVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        ActionBlockVisitor() {
        }

        public boolean visit(RfHidOperator hid) {
            if (hid == null) {
                return true;
            }
            if (hid.isEventControl()) {
                Set operators = HidUtils.flattenToOperators((IHidOperator)hid);
                if (operators == null || operators.isEmpty()) {
                    return true;
                }
                for (IHidOperator operator : operators) {
                    RfHidOperator hidOperator;
                    if (!(operator instanceof RfHidOperator) || !(hidOperator = (RfHidOperator)operator).isAnyEdgeEvent()) continue;
                    Check_R_1123.this.addHit(this.parserPath, (HidOccurrence)hid.getOccurrence(), "Do not use edge delay inside while loop!");
                    return true;
                }
                return true;
            }
            if (hid.isVlogDelayControlStatement()) {
                Check_R_1123.this.addHit(this.parserPath, (HidOccurrence)hid.getOccurrence(), "Do not use delay inside while loop!");
                return true;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

