/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="22.1.1")
@CheckID(value="R.1124")
@CheckName(value="R.1124")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use multiple `xvm_info macro calls inside methods")
@CheckDescription(value="In order to have only the necessary messages in logs, do not use multiple `xvm_info macro calls inside methods.\n\nCheck supports pre-waiving.")
public class Check_R_1124
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of XVM verbosities. When empty XVM_NONE and XVM_LOW will be the checked verbosities", name="bannedVerbosity", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedVerbosity;
    @CheckParameter(defaultValue="2", description="Maximum number of `xvm_info macro calls allowed.", name="maxNofMacroCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pMaxNofMacroCalls;
    private static Set<String> ovmVerbosity = new HashSet<String>(Arrays.asList("OVM_NONE", "OVM_LOW", "OVM_MEDIUM", "OVM_HIGH", "OVM_FULL", "OVM_DEBUG"));
    private static Set<String> uvmVerbosity = new HashSet<String>(Arrays.asList("UVM_NONE", "UVM_LOW", "UVM_MEDIUM", "UVM_HIGH", "UVM_FULL", "UVM_DEBUG"));
    private String XVM_INFO;

    public Check_R_1124(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.XVM_INFO = oVMProject.getLibraryKind() == 1 ? "`ovm_info" : "`uvm_info";
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pBannedVerbosity.isEmpty()) {
            this.pBannedVerbosity.add(OVMUtils.prependCapitalizedLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_NONE"));
            this.pBannedVerbosity.add(OVMUtils.prependCapitalizedLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_LOW"));
            return;
        }
        for (String verbosity : this.pBannedVerbosity) {
            if (this.fOVMProject.getLibraryKind() == 1) {
                if (ovmVerbosity.contains(verbosity)) continue;
                this.signalParamError("Invalid verbosity: '" + verbosity + "'!", true);
                continue;
            }
            if (this.fOVMProject.getLibraryKind() != 2 || uvmVerbosity.contains(verbosity)) continue;
            this.signalParamError("Invalid verbosity: '" + verbosity + "'!", true);
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        super.preBuildNotification(aRfProject);
        aRfProject.lintTrackMacrosByNames("function", new HashSet<String>(Arrays.asList(this.XVM_INFO)));
        aRfProject.lintTrackMacrosByNames("constructor", new HashSet<String>(Arrays.asList(this.XVM_INFO)));
        aRfProject.lintTrackMacrosByNames("task", new HashSet<String>(Arrays.asList(this.XVM_INFO)));
    }

    @Override
    public void performCheckImpl() {
        RfDefElement declaration;
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            this.notifyCheckAlive();
            declaration = function.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this) || !(function instanceof RfFunction)) continue;
            this.checkMethod((RfFunction)function);
        }
        for (RfNamedElement task : this.fOVMProject.getAllTasks()) {
            this.notifyCheckAlive();
            declaration = task.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this) || !(task instanceof RfFunction)) continue;
            this.checkMethod((RfFunction)task);
        }
    }

    private void checkMethod(RfFunction method) {
        MacroCallInfo macroCallInfo = method.getMacroCallInfo();
        if (macroCallInfo == null) {
            return;
        }
        List<MacroCallItem> items = macroCallInfo.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        int count = 0;
        for (MacroCallItem item : items) {
            String[] macroParameters;
            if (item == null || !this.XVM_INFO.equals(item.getName()) || !this.pBannedVerbosity.contains((macroParameters = item.getMacroParameters())[2]) || ++count <= this.pMaxNofMacroCalls) continue;
            this.addHit(item.getParserPath(), item.getLineNumber(), "Multiple " + this.XVM_INFO + " macro calls with banned verbosity inside method '" + LintUtils.getNamedElementFullName(method) + "'!", item.getReparseInfo());
        }
    }
}

