/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.2")
@CheckID(value="R.1126")
@CheckName(value="R.1126")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="'end' must be placed on the same line or the previous line consistently in the same file")
@CheckDescription(value="A file must have the same 'end' placement for every block. This can be either on the same line or the previous line with what caused the 'end'.\n\nExamples:\nif (a == 1) begin\nend else begin // allowed\nend\n\ndo begin\n  h = a;\nend while (f == g); // allowed\n\ndo begin\n  h = a;\nend // not allowed\nwhile (f == g);\n\nCheck supports pre-waiving.")
public class Check_R_1126
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of action block kinds which are not checked and are not counted when determining the predominant code style in the file. Possible values: if, do-while, fork-join", name="skipActionBlockKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipActionBlockKind;
    @CheckParameter(defaultValue="false", description="When true, checks if the 'end' keyword is placed consistently over the block types that are of the same kind in the same file.", name="checkBlockConsistency", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckBlockConsistency;
    private static final String WHILE = "while";
    private static final String BEGIN = "begin";
    private static final String ELSE = "else";
    private static final String END = "end";
    private static final int ITERATION_LIMIT = 5;
    private static final String IF = "if";
    private static final String DO_WHILE = "do-while";
    private static final String FORK_JOIN = "fork-join";
    private Map<ParserPath, List<EndInfo>> sameLineEndsMap;
    private Map<ParserPath, List<EndInfo>> previousLineEndsMap;
    private Map<ParserPath, Map<String, List<EndInfo>>> sameLineByCategory;
    private Map<ParserPath, Map<String, List<EndInfo>>> previousLineByCategory;

    public Check_R_1126(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        List<String> acceptedValues = Arrays.asList(IF, DO_WHILE, FORK_JOIN);
        for (String block : this.pSkipActionBlockKind) {
            if (acceptedValues.contains(block)) continue;
            this.signalParamError("'" + block + "' is not an allowed action block!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        if (!this.pCheckBlockConsistency) {
            this.sameLineEndsMap = new HashMap<ParserPath, List<EndInfo>>();
            this.previousLineEndsMap = new HashMap<ParserPath, List<EndInfo>>();
        } else {
            this.sameLineByCategory = new HashMap<ParserPath, Map<String, List<EndInfo>>>();
            this.previousLineByCategory = new HashMap<ParserPath, Map<String, List<EndInfo>>>();
        }
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!(namedElement instanceof RfActionBlock)) {
                return true;
            }
            RfActionBlock block = (RfActionBlock)namedElement;
            if (!block.hasBeginEnd()) {
                return true;
            }
            ParserPath path = block.getFile().getParserPath();
            if (this.checkPreWaivers(path)) {
                return true;
            }
            this.notifyCheckAlive();
            if (!this.pCheckBlockConsistency) {
                this.sameLineEndsMap.putIfAbsent(path, new LinkedList());
                this.previousLineEndsMap.putIfAbsent(path, new LinkedList());
            } else {
                this.sameLineByCategory.putIfAbsent(path, new HashMap());
                this.previousLineByCategory.putIfAbsent(path, new HashMap());
            }
            if ((block.isIf() || block.isElsIf()) && !this.pSkipActionBlockKind.contains(IF)) {
                this.count(block, path, ELSE);
                return true;
            }
            if (block.isDoWhile() && !this.pSkipActionBlockKind.contains(DO_WHILE)) {
                this.countDoWhile(block, path);
                return true;
            }
            if (!this.pSkipActionBlockKind.contains(FORK_JOIN)) {
                RfNamedElement enclosingScope = block.getEnclosingScope();
                while (enclosingScope instanceof RfActionBlock) {
                    if (((RfActionBlock)enclosingScope).isForkJoin()) {
                        this.count(block, path, BEGIN);
                        return true;
                    }
                    enclosingScope = enclosingScope.getEnclosingScope();
                }
            }
            return true;
        });
        Set<ParserPath> pathSet = !this.pCheckBlockConsistency ? this.sameLineEndsMap.keySet() : this.sameLineByCategory.keySet();
        for (ParserPath path : pathSet) {
            List<EndInfo> previousLineEnds;
            List<EndInfo> sameLineEnds;
            if (!this.pCheckBlockConsistency) {
                sameLineEnds = this.sameLineEndsMap.get(path);
                previousLineEnds = this.previousLineEndsMap.get(path);
                this.reportIssue(path, sameLineEnds, previousLineEnds, null);
                continue;
            }
            Map<String, List<EndInfo>> sameLineEndsByCategory = this.sameLineByCategory.get(path);
            for (Map.Entry<String, List<EndInfo>> entry : sameLineEndsByCategory.entrySet()) {
                sameLineEnds = entry.getValue();
                previousLineEnds = this.previousLineByCategory.get(path).get(entry.getKey());
                if (sameLineEnds == null || previousLineEnds == null) continue;
                this.reportIssue(path, sameLineEnds, previousLineEnds, entry.getKey());
            }
        }
    }

    private void reportIssue(ParserPath path, List<EndInfo> sameLineEnds, List<EndInfo> previousLineEnds, String blockType) {
        if (sameLineEnds.size() >= previousLineEnds.size()) {
            for (EndInfo info : previousLineEnds) {
                this.addHit(path, info.line, "'end' statement not on the same line with the '" + info.cause + "' statement that follows it, most 'end' statements " + (this.pCheckBlockConsistency ? "caused by " + "'" + blockType + "'" + " statements " : "") + "are on the same line in this file!", null);
            }
        } else {
            for (EndInfo info : sameLineEnds) {
                this.addHit(path, info.line, "'end' statement on the same line with the '" + info.cause + "' statement that caused it, most 'end' statements " + (this.pCheckBlockConsistency ? "caused by " + "'" + blockType + "'" + " statements " : "") + "are not on the same line in this file!", null);
            }
        }
    }

    private void count(RfActionBlock block, ParserPath path, String value) {
        int offset = block.getEndOffset() - END.length();
        LiteralToken token = this.getWSParser().getToken(offset, path);
        LiteralToken nextToken = this.getWSParser().getNextToken(token, path);
        if (token == null || nextToken == null) {
            return;
        }
        if (nextToken.getStringToken().contains(value)) {
            EndInfo endInfo = new EndInfo(token.getLineNumber(), value);
            if (token.getLineNumber() == nextToken.getLineNumber()) {
                if (!this.pCheckBlockConsistency) {
                    this.sameLineEndsMap.get(path).add(endInfo);
                } else {
                    this.sameLineByCategory.get(path).putIfAbsent(value, new ArrayList());
                    this.sameLineByCategory.get(path).get(value).add(endInfo);
                }
            } else if (!this.pCheckBlockConsistency) {
                this.previousLineEndsMap.get(path).add(endInfo);
            } else {
                this.previousLineByCategory.get(path).putIfAbsent(value, new ArrayList());
                this.previousLineByCategory.get(path).get(value).add(endInfo);
            }
        }
    }

    private void countDoWhile(RfActionBlock block, ParserPath path) {
        LiteralToken token = this.getWSParser().getTokenContainingOffset(block.getEndOffset(), path);
        if (token == null) {
            return;
        }
        LiteralToken endToken = null;
        LiteralToken whileToken = null;
        int i = 0;
        while (i < 5) {
            if (token.getStringToken().contains(WHILE)) {
                whileToken = token;
            }
            if (token.getStringToken().contains(END)) {
                endToken = token;
                break;
            }
            token = this.getWSParser().getPrevToken(token, path);
            ++i;
        }
        if (endToken != null && whileToken != null) {
            EndInfo endInfo = new EndInfo(endToken.getLineNumber(), WHILE);
            if (endToken.getLineNumber() == whileToken.getLineNumber()) {
                if (!this.pCheckBlockConsistency) {
                    this.sameLineEndsMap.get(path).add(endInfo);
                } else {
                    this.sameLineByCategory.get(path).putIfAbsent(WHILE, new ArrayList());
                    this.sameLineByCategory.get(path).get(WHILE).add(endInfo);
                }
            } else if (!this.pCheckBlockConsistency) {
                this.previousLineEndsMap.get(path).add(new EndInfo(endToken.getLineNumber(), WHILE));
            } else {
                this.previousLineByCategory.get(path).putIfAbsent(WHILE, new ArrayList());
                this.previousLineByCategory.get(path).get(WHILE).add(endInfo);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static class EndInfo {
        int line;
        String cause;

        EndInfo(int line, String cause) {
            this.line = line;
            this.cause = cause;
        }
    }
}

