/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="22.1.1")
@CheckID(value="R.1127")
@CheckName(value="R.1127")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CONDITIONAL, RuleLabel.CASE})
@CheckTitle(value="Don't use case variable in the case item expression")
@CheckDescription(value="Case item expressions should not contain case variable.\n\nExamples:\ncase (x)\n  x == 1: ... ;  // not allowed\n  x == 2: ... ;  // not allowed\nendcase\ncase (1)\n  x == 1: ... ;  // allowed\n  x == 2: ... ;  // allowed\nendcase\n\nCheck supports pre-waiving.")
public class Check_R_1127
extends OVMComplianceCheck {
    public Check_R_1127(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> allActionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : allActionBlocks) {
            IHidObject caseExprHidObject;
            List<IHidOperator> caseOperator;
            this.notifyCheckAlive();
            if (!actionBlock.isCase() || this.fOVMProject.getProjectWaivers().pathIsPrewaived(actionBlock.getDeclaration().getParserPath(), this) || (caseOperator = actionBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION}, true)) == null || caseOperator.isEmpty() || caseOperator.size() != 1 || !((caseExprHidObject = caseOperator.get(0).getLHValue()) instanceof RfHid)) continue;
            RfHid caseExprHid = (RfHid)caseExprHidObject;
            Collection<RfNamedElement> caseItems = actionBlock.getMembers();
            if (caseItems == null || caseItems.isEmpty()) continue;
            for (RfNamedElement caseItem : caseItems) {
                Set caseItemExprHids;
                List<IHidOperator> caseItemExprOperator;
                if (!(caseItem instanceof RfActionBlock) || !((RfActionBlock)caseItem).isCaseItem() || (caseItemExprOperator = ((RfActionBlock)caseItem).getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION}, true)) == null || caseItemExprOperator.isEmpty() || caseItemExprOperator.size() != 1 || (caseItemExprHids = caseItemExprOperator.get(0).getRHHids(HidFlatteningOption.IMPLICITS_EXCLUDED)) == null || caseItemExprHids.isEmpty() || !caseItemExprHids.contains((Object)caseExprHid)) continue;
                this.addHit(caseItem, "Case variable '" + LintUtils.getHidFullName((IHid)caseExprHid) + "' is used in case item expression!");
            }
        }
    }
}

