/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

@CheckVersion(value="22.1.2")
@CheckID(value="R.1128")
@CheckName(value="R.1128")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.STRING, RuleLabel.OPERATOR, RuleLabel.CONCATENATION})
@CheckTitle(value="Do not use single element concatenations")
@CheckDescription(value="Performing concatenation for a single element is unnecessary and it might affect the performance.\n\nvar2 = {1};                      // not allowed\nstr2 = {str1};                   // not allowed\nstr2 = {str1, \"another string\"}; // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1128
extends OVMComplianceCheck {
    private Map<ParserPath, Map<HidOccurrence, RfHidOperator>> concatenationOperators;
    private Map<ParserPath, Set<HidOccurrence>> concatenationsAssignedToArrayDeclarations;

    public Check_R_1128(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.concatenationsAssignedToArrayDeclarations = new HashMap<ParserPath, Set<HidOccurrence>>();
        this.visitForConcatenationsAssignedToArrays();
        this.concatenationOperators = new HashMap<ParserPath, Map<HidOccurrence, RfHidOperator>>();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
        for (Map.Entry<ParserPath, Map<HidOccurrence, RfHidOperator>> entry : this.concatenationOperators.entrySet()) {
            ParserPath parserPath = entry.getKey();
            Collection<RfHidOperator> operators = entry.getValue().values();
            for (RfHidOperator operator : operators) {
                this.addHit(parserPath, operator, operator.getQualifiers(), "Single element concatenation not allowed in '" + HidUtils.toNiceString((IHidObject)operator) + "'!");
            }
            operators.clear();
        }
        this.concatenationOperators.clear();
    }

    private void visitForConcatenationsAssignedToArrays() {
        this.fOVMProject.getRfProject().visitHidObject(null, new AssignmentOperatorVisitor());
        this.fOVMProject.getRfProject().visitHidObject(null, new MethodArguments());
    }

    private void analyzeOperator(RfHidOperator operator, RfNamedElement scope, ParserPath parserPath) {
        Object lhValueHidObject;
        IHidObject rhHidObject = operator.getFirstRHValue();
        if (rhHidObject == null || !(rhHidObject instanceof RfHidOperator)) {
            return;
        }
        if (!(rhHidObject instanceof RfHidOperator)) {
            return;
        }
        RfHidOperator rhOperator = (RfHidOperator)rhHidObject;
        if (!rhOperator.isVLOGConcatenation(true)) {
            return;
        }
        if (operator.isReturnStatement()) {
            RfFunction enclosingFunc = scope.getEnclosingScope(RfFunction.class);
            lhValueHidObject = STransformer.makeStandInHid(enclosingFunc.getName(), enclosingFunc, new HidOccurrence(operator.getOccurrence().getOffset(), operator.getOccurrence().getVirtualOffset(), operator.getOccurrence().getLine(), 0L, null), 0L);
        } else if (operator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER)) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            if (resolvedType == null) {
                return;
            }
            if (!(resolvedType instanceof SDataVariable)) {
                return;
            }
            IRfNamedElement declarationAssignElement = ((SDataVariable)resolvedType).getVariable();
            if (declarationAssignElement == null) {
                return;
            }
            lhValueHidObject = STransformer.makeStandInHid(declarationAssignElement.getName(), declarationAssignElement, new HidOccurrence(operator.getOccurrence().getOffset(), operator.getOccurrence().getVirtualOffset(), operator.getOccurrence().getLine(), 0L, null), 0L);
        } else {
            lhValueHidObject = operator.getLHValue();
        }
        if (!(lhValueHidObject instanceof RfHid)) {
            return;
        }
        RfHid lhHid = (RfHid)((Object)lhValueHidObject);
        IRfNamedElement lhElement = lhHid.getElement();
        if (!(lhElement instanceof RfAssociatedType)) {
            return;
        }
        IRfNamedElement associatedType = ((RfAssociatedType)lhElement).getAssociatedType();
        if (associatedType instanceof RfListType) {
            this.concatenationsAssignedToArrayDeclarations.putIfAbsent(parserPath, new HashSet());
            this.concatenationsAssignedToArrayDeclarations.get(parserPath).add((HidOccurrence)rhOperator.getOccurrence());
        }
    }

    public boolean isPreWaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.concatenationOperators != null) {
            this.concatenationOperators.clear();
        }
        if (this.concatenationsAssignedToArrayDeclarations != null) {
            this.concatenationsAssignedToArrayDeclarations.clear();
        }
    }

    private class AssignmentOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        private AssignmentOperatorVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            if (Check_R_1128.this.isPreWaived(this.parserPath)) {
                return true;
            }
            Check_R_1128.this.notifyCheckAlive();
            if (!operator.isAssignment()) {
                return true;
            }
            Check_R_1128.this.analyzeOperator(operator, this.scope, this.parserPath);
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isVLOGConcatenation(true)) {
                return true;
            }
            if (Check_R_1128.this.isPreWaived(this.parserPath)) {
                return true;
            }
            Check_R_1128.this.notifyCheckAlive();
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            if (rhValues.size() == 1) {
                if (Check_R_1128.this.concatenationsAssignedToArrayDeclarations.containsKey(this.parserPath) && Check_R_1128.this.concatenationsAssignedToArrayDeclarations.get(this.parserPath).contains(hidObject.getOccurrence())) {
                    return true;
                }
                Map<HidOccurrence, RfHidOperator> concatenations = Check_R_1128.this.concatenationOperators.get(this.parserPath);
                if (concatenations == null) {
                    concatenations = new HashMap<HidOccurrence, RfHidOperator>();
                }
                concatenations.put((HidOccurrence)hidObject.getOccurrence(), hidObject);
                Check_R_1128.this.concatenationOperators.put(this.parserPath, concatenations);
            } else if (rhValues.size() == 3) {
                IHidObject implicit = (IHidObject)rhValues.get(1);
                if (!(implicit instanceof RfHidImplicit)) {
                    return true;
                }
                RfHidImplicit hidImplict = (RfHidImplicit)implicit;
                if (hidImplict.getType() != IHidImplicitConstants.ImplicitType.CONCATENATION_REPLICATION.id) {
                    return true;
                }
                IHidObject operator = (IHidObject)rhValues.get(0);
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator concatenationOperator = (RfHidOperator)operator;
                if (!concatenationOperator.isVLOGConcatenation(true)) {
                    return true;
                }
                Map<HidOccurrence, RfHidOperator> concatenations = Check_R_1128.this.concatenationOperators.get(this.parserPath);
                if (concatenations == null) {
                    return true;
                }
                concatenations.remove(concatenationOperator.getOccurrence());
                Check_R_1128.this.concatenationOperators.put(this.parserPath, concatenations);
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private class MethodArguments
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        private MethodArguments() {
        }

        public boolean visit(RfHid hidObject) {
            if (Check_R_1128.this.isPreWaived(this.parserPath)) {
                return true;
            }
            Check_R_1128.this.notifyCheckAlive();
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfFunction)) {
                return true;
            }
            if (!(hidObject.getFirstAccess() instanceof RfHidAccessArgs)) {
                return true;
            }
            List<? extends IHidObject> argumentValues = ((RfHidAccessArgs)hidObject.getFirstAccess()).getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty()) {
                return true;
            }
            for (IHidObject iHidObject : argumentValues) {
                if (!(iHidObject instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator operator = (RfHidOperator)iHidObject;
                Check_R_1128.this.analyzeOperator(operator, this.scope, this.parserPath);
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

