/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.2")
@CheckID(value="R.1129")
@CheckName(value="R.1129")
@CheckLabel(labels={RuleLabel.CONSTRAINT, RuleLabel.FUNCTIONAL, RuleLabel.RANDOMIZATION, RuleLabel.VERIFICATION, RuleLabel.DISTRIBUTION})
@CheckTitle(value="Do not use fractional randomization weights")
@CheckDescription(value="If the weight is specified as a ratio of two integers such that the effective value is less than 1, then that weight is treated as 0 and will never take effect.\nReal values greater than or equal to 1 used for randomization weights are allowed.\n\nExamples:\nclass my_class;\n  rand int data;\n  constraint c1 {\n    data dist {111 := 1/2, 222 := 2};  // not allowed\n  }\n  constraint c2 {\n    data dist {111 := 0.5, 222 := 2};  // not allowed\n  }\n  constraint c3 {\n    data dist {111 := 3/2, 222 := 2.5};  // allowed\n  }\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1129
extends OVMComplianceCheck {
    public static final Pattern SUBUNIT_REAL_NUM_PATTERN = Pattern.compile("0\\.[0-9]+");

    public Check_R_1129(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement constraintElement : this.fOVMProject.getAllConstraints()) {
            this.notifyCheckAlive();
            RfDefElement declaration = constraintElement.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this) || !(constraintElement instanceof RfConstraint)) continue;
            RfConstraint constraint = (RfConstraint)constraintElement;
            constraint.visitHidObject(null, new LocalConstraintVisitor(LintUtils.getNamedElementFullName(constraint)));
        }
    }

    class LocalConstraintVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;
        String constraintName;

        LocalConstraintVisitor(String constraintName) {
            this.constraintName = constraintName;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (!hidObject.isDistribution()) {
                return true;
            }
            Set flattenToOperators = HidUtils.flattenToOperators((IHidOperator)hidObject);
            for (IHidOperator operator : flattenToOperators) {
                ListContainer rhValuesOfDiv;
                IHidObject lhValueOfDiv;
                ListContainer rhValuesOfColon;
                if (!(operator instanceof RfHidOperator) || !((RfHidOperator)operator).isColonEq() && !((RfHidOperator)operator).isColonDiv() || !((rhValuesOfColon = operator.getRHValues()) instanceof RfHidOperator) && !(rhValuesOfColon instanceof RfHidImplicit)) continue;
                if (rhValuesOfColon instanceof RfHidImplicit) {
                    if (!SUBUNIT_REAL_NUM_PATTERN.matcher(((RfHidImplicit)rhValuesOfColon).getName()).matches()) continue;
                    Check_R_1129.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Disribution ratio of constraint '" + this.constraintName + "' is using fractional weight: " + ((RfHidImplicit)rhValuesOfColon).getName() + "!");
                    continue;
                }
                if (!((RfHidOperator)rhValuesOfColon).isDiv() || !((lhValueOfDiv = ((RfHidOperator)rhValuesOfColon).getLHValue()) instanceof RfHidImplicit) || !((rhValuesOfDiv = ((RfHidOperator)rhValuesOfColon).getRHValues()) instanceof RfHidImplicit)) continue;
                RfHidImplicit leftImplicit = (RfHidImplicit)lhValueOfDiv;
                RfHidImplicit rightImplicit = (RfHidImplicit)rhValuesOfDiv;
                if (!LintUtils.isDecimalNumber(leftImplicit.getName()) || !LintUtils.isDecimalNumber(rightImplicit.getName()) || Integer.valueOf(leftImplicit.getName()) >= Integer.valueOf(rightImplicit.getName())) continue;
                Check_R_1129.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Distribution ratio of constraint '" + this.constraintName + "' is using fractional weight: " + LintUtils.trimParens(HidUtils.toNiceString((IHidObject)((RfHidOperator)rhValuesOfColon))) + "!");
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

