/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.3")
@CheckID(value="R.1130")
@CheckName(value="R.1130")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.CONSTRAINT, RuleLabel.FUNCTIONAL, RuleLabel.RANDOMIZATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Constraint unsigned variable should use a positive value")
@CheckDescription(value="A constraint which attempts to restrict an unsigned variable to a negative value, will cause a positive result to be generated.\nSince the variable cannot take on negative values, the resulting value will be generated such that the bit-vector is equivalent to the two's complement value of the intended negative value.\n\nExamples:\nclass my_class;\n  int unsigned bad_value;\n  int unsigned good_value;\n  constraint value_c {\n    bad_value == -2;  // not allowed\n    good_value == 2;  // allowed\n  endcovergroup\nendclass\n\nprogram my_randomize;\n  int unsigned data1;\n  int data2;\n  initial begin\n    randomize(data1, data2) with { \n      data1 == - 3; // not allowed\n      data2 ==  -4; // allowed\n    };\n  end\nendprogram\n\nCheck supports pre-waiving.")
public class Check_R_1130
extends OVMComplianceCheck {
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(482, 483, 484, 485, 502, 504, 486, 487, 488, 489));
    private final HidOperatorVisitor comparisonVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidOperator) {
            int operatorType = hidOperator.getOperatorType();
            if (!OPERATOR_TYPE_TOKENS.contains(operatorType)) {
                return true;
            }
            if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                return true;
            }
            if (Check_R_1130.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!this.isInConstraint((RfNamedElement)this.scope)) {
                return true;
            }
            Check_R_1130.this.notifyCheckAlive();
            IHidObject lhValue = hidOperator.getLHValue();
            if (lhValue == null) {
                return true;
            }
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.iterator().next();
            if (this.isHit(lhValue, rhValue)) {
                Check_R_1130.this.addHit(this.parserPath, (RfHid)lhValue, "Constraint unsigned variable '" + this.getFullName(lhValue) + "' is used with a negative value '" + HidUtils.toNiceString((IHidObject)rhValue) + "'!");
            }
            if (this.isHit(rhValue, lhValue)) {
                Check_R_1130.this.addHit(this.parserPath, (RfHid)rhValue, "Constraint unsigned variable '" + this.getFullName(rhValue) + "' is used with a negative value' " + HidUtils.toNiceString((IHidObject)lhValue) + "'!");
            }
            return true;
        }

        private String getFullName(IHidObject hidObject) {
            if (!(hidObject instanceof RfHid)) {
                return "null";
            }
            RfHid hid = (RfHid)hidObject;
            if (!(hid.getElement() instanceof RfField)) {
                return hid.getName();
            }
            RfField field = (RfField)hid.getElement();
            return field.getFullName();
        }

        private boolean isHit(IHidObject lhValue, IHidObject rhValue) {
            if (!(lhValue instanceof RfHid)) {
                return false;
            }
            RfHid lhHid = (RfHid)lhValue;
            if (!(lhHid.getElement() instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)lhHid.getElement();
            DataType dataType = field.getDataType();
            if (dataType == null) {
                return false;
            }
            if (LintUtils.isSigned(dataType)) {
                return false;
            }
            if (!(rhValue instanceof RfHidOperator)) {
                return false;
            }
            RfHidOperator operator = (RfHidOperator)rhValue;
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                return false;
            }
            if (operator.getOperatorType() != 467) {
                return false;
            }
            IHidObject implicitHid = operator.getLHValue();
            if (!(implicitHid instanceof RfHidImplicit)) {
                return false;
            }
            return ((RfHidImplicit)implicitHid).isNumber();
        }

        private boolean isInConstraint(RfNamedElement scope) {
            while (scope != null) {
                if (scope instanceof RfConstraint || scope instanceof RfActionBlock && ((RfActionBlock)scope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.WITH)) {
                    return true;
                }
                scope = scope.getEnclosingScope();
            }
            return false;
        }
    };

    public Check_R_1130(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(null, (IHidVisitor<?>)this.comparisonVisitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

