/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="22.1.3")
@CheckID(value="R.1132")
@CheckName(value="R.1132")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Assertions should not contain function or system calls")
@CheckDescription(value="Calling a function or system method inside an imediate assertion is not allowed.\nThis rule prohibits calling methods or functions within immediate assertions because some simulators allow the user the ability to disable assertions entirely.\n\nExamples:\nassert(obj.randomize());  // not allowed\nassert(a || b);           // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1132
extends OVMComplianceCheck {
    public Check_R_1132(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertion : this.fOVMProject.getAllAssertsExpects()) {
            RfDefElement declaration;
            RfAssertExpect assertionExpect;
            if (!(assertion instanceof RfAssertExpect) || !(assertionExpect = (RfAssertExpect)assertion).isImmediateAssert() || (declaration = assertionExpect.getDeclaration()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            IHidObject expression = assertionExpect.getExpression();
            Set hids = HidUtils.flattenToHids((IHidObject)expression, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
            for (IHid hid : hids) {
                IRfNamedElement element;
                RfHid rfHid;
                if (!(hid instanceof RfHid) || !(rfHid = (RfHid)hid).isMethodCall(false) || !((element = rfHid.getElement()) instanceof RfFunction)) continue;
                this.addHit(assertion, "Illegal method call in imediate assertion: '" + HidUtils.toNiceString((IHidObject)rfHid) + "'!");
            }
        }
    }
}

