/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractForLoopCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.4")
@CheckID(value="R.1133")
@CheckName(value="R.1133")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.LOOP, RuleLabel.FOR})
@CheckTitle(value="For loop must have a step statement")
@CheckDescription(value="This check flags for loops without a step statement.\nDeclaring a for loop without a step statement has been a non-standard construct until the IEEE 1800-2012 version of the Standard for System Verilog.\n\nCheck supports pre-waiving.")
public class Check_R_1133
extends AbstractForLoopCheck {
    public Check_R_1133(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean checkLoopOperators(ListContainer<IHidObject> loopOperators) {
        for (IHidObject operator : loopOperators) {
            if (!(operator instanceof RfHidOperator) || !((RfHidOperator)operator).isForStep()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getHitMessage() {
        return "For loop has no step statement!";
    }

    @Override
    protected void addHits(RfNamedElement namedElement) {
        this.addHit(namedElement, this.getHitMessage());
    }
}

