/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.6")
@CheckID(value="R.1135")
@CheckName(value="R.1135")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FORWARD_TYPEDEF, RuleLabel.PACKAGE, RuleLabel.IMPORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Forward typedefs must be before import statements")
@CheckDescription(value="This rule checks that inside packages forward typedef statements are declared before their corresponding import statements.\n\nExample:\ntypedef class class1;\nimport my_pkg::class1;  // allowed\nimport my_pkg::class2;  // not allowed\ntypedef class class2;\n\nCheck supports pre-waiving.")
public class Check_R_1135
extends OVMComplianceCheck {
    public Check_R_1135(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IHidVisitorImplementation visitor = new IHidVisitorImplementation();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        for (Map.Entry<RfPackage, List<PackageImportInfo>> entry : visitor.getImportStatements().entrySet()) {
            RfPackage importScope = entry.getKey();
            List<PackageImportInfo> imports = entry.getValue();
            List<PackageTypedefInfo> forwardTypedefs = visitor.getForwardTypedeffs().get(importScope);
            if (forwardTypedefs == null || forwardTypedefs.isEmpty()) continue;
            this.notifyCheckAlive();
            for (PackageImportInfo importStatement : imports) {
                RfPackage importedPackage;
                IHidObject lhValue = importStatement.getImportOperator().getLHValue();
                ListContainer rhValues = importStatement.getImportOperator().getRHValues();
                if (!(lhValue instanceof RfHidImplicit) || (importedPackage = this.getPackageWithName(((RfHidImplicit)lhValue).getName())) == null) continue;
                for (IHidObject value : rhValues) {
                    if (!(value instanceof RfHidImplicit)) continue;
                    boolean isStarImport = ((RfHidImplicit)value).getName().equals("*");
                    if (isStarImport) {
                        this.checkHitStarImport(forwardTypedefs, importedPackage, importStatement, importScope);
                        continue;
                    }
                    this.checkHit(forwardTypedefs, (RfHidImplicit)value, importedPackage, importStatement, importScope);
                }
            }
        }
    }

    private void checkHitStarImport(List<PackageTypedefInfo> forwardTypedefs, RfPackage importedPackage, PackageImportInfo importStatement, RfPackage importScope) {
        for (PackageTypedefInfo typedef : forwardTypedefs) {
            RfPackage classScope;
            RfHid typedefHid = typedef.getTypedef();
            IRfNamedElement element = typedefHid.getElement();
            if (!(element instanceof RfClass) || !importedPackage.equals(classScope = ((RfClass)element).getEnclosingScope(RfPackage.class))) continue;
            if (this.isHitWithInclude(importStatement, typedef, importScope)) {
                this.addHit(importStatement.getImportParserPath(), (HidOccurrence)importStatement.getImportOperator().getOccurrence(), "The forward typedef " + this.link(HidUtils.toNiceString((IHidObject)typedef.getTypedef()), typedef.getTypedefParserPath().path, typedef.getTypedef().getOccurrence().getLine()) + " is placed after the " + this.link(HidUtils.toNiceString((IHidObject)importStatement.getImportOperator()), importStatement.getImportParserPath().path, importStatement.getImportOperator().getOccurrence().getLine()) + " import statement in package " + this.link(importScope.getName(), importScope.getDeclaration().getParserPath().path, importScope.getLine()) + "!");
                continue;
            }
            if (typedef.getTypedef().getOccurrence().getLine() <= importStatement.getImportOperator().getOccurrence().getLine()) continue;
            this.addHit(importStatement.getPackageParserPath(), (HidOccurrence)importStatement.getImportOperator().getOccurrence(), "The forward typedef " + this.link(HidUtils.toNiceString((IHidObject)typedef.getTypedef()), typedef.getTypedefParserPath().path, typedef.getTypedef().getOccurrence().getLine()) + " is placed after the " + this.link(HidUtils.toNiceString((IHidObject)importStatement.getImportOperator()), importStatement.getImportParserPath().path, importStatement.getImportOperator().getOccurrence().getLine()) + " import statement in package " + this.link(importScope.getName(), importScope.getDeclaration().getParserPath().path, importScope.getLine()) + "!");
        }
    }

    private void checkHit(List<PackageTypedefInfo> forwardTypedefs, RfHidImplicit value, RfPackage importedPackage, PackageImportInfo importStatement, RfPackage importScope) {
        for (PackageTypedefInfo typedef : forwardTypedefs) {
            IRfNamedElement element = typedef.getTypedef().getElement();
            if (!(element instanceof RfClass)) continue;
            RfClass typedeffClass = (RfClass)element;
            RfClass importedClass = importedPackage.getClassWithPrefix(value.getName(), 1, 1);
            if (importedClass == null || !importedClass.equals(typedeffClass)) continue;
            if (this.isHitWithInclude(importStatement, typedef, importScope)) {
                this.addHit(importStatement.getImportParserPath(), (HidOccurrence)importStatement.getImportOperator().getOccurrence(), "The forward typedef " + this.link(HidUtils.toNiceString((IHidObject)typedef.getTypedef()), typedef.getTypedefParserPath().path, typedef.getTypedef().getOccurrence().getLine()) + " is placed after the " + this.link(HidUtils.toNiceString((IHidObject)importStatement.getImportOperator()), importStatement.getImportParserPath().path, importStatement.getImportOperator().getOccurrence().getLine()) + " import statement in package " + this.link(importScope.getName(), importScope.getDeclaration().getParserPath().path, importScope.getLine()) + "!");
                continue;
            }
            HidOccurrence typedeffOccurrence = typedef.getTypedef().getOccurrence();
            HidOperatorOccurrence importOccurrence = importStatement.getImportOperator().getOccurrence();
            if (typedeffOccurrence == null || importOccurrence == null || typedeffOccurrence.getLine() <= importOccurrence.getLine()) continue;
            this.addHit(importStatement.getPackageParserPath(), (HidOccurrence)importOccurrence, "The forward typedef " + this.link(HidUtils.toNiceString((IHidObject)typedef.getTypedef()), typedef.getTypedefParserPath().path, typedef.getTypedef().getOccurrence().getLine()) + " is placed after the " + this.link(HidUtils.toNiceString((IHidObject)importStatement.getImportOperator()), importStatement.getImportParserPath().path, importStatement.getImportOperator().getOccurrence().getLine()) + " import statement in package " + this.link(importScope.getName(), importScope.getDeclaration().getParserPath().path, importScope.getLine()) + "!");
        }
    }

    private boolean isHitWithInclude(PackageImportInfo importStatement, PackageTypedefInfo typedef, RfPackage importScope) {
        ParserPath packageParserPath = importStatement.getPackageParserPath();
        ParserPath importParserPath = importStatement.getImportParserPath();
        ParserPath typedefParserPath = typedef.getTypedefParserPath();
        boolean samePathPackageAndImport = packageParserPath.equals((Object)importParserPath);
        boolean samePathPackageAndTypedef = packageParserPath.equals((Object)typedefParserPath);
        if (samePathPackageAndImport && samePathPackageAndTypedef) {
            return false;
        }
        Map includedFilesMap = this.fOVMProject.getAllFilesWithIncludes().get(packageParserPath);
        if (includedFilesMap == null || includedFilesMap.isEmpty()) {
            return false;
        }
        List includeFileWithImportLine = (List)includedFilesMap.get(importParserPath);
        List includeFileWithTypedefLine = (List)includedFilesMap.get(typedefParserPath);
        int startLine = importScope.getLine();
        int endLine = importScope.getEndLine();
        if (!samePathPackageAndImport && !samePathPackageAndTypedef) {
            if (includeFileWithTypedefLine == null || includeFileWithImportLine == null) {
                return false;
            }
            for (Integer importLine : includeFileWithImportLine) {
                for (Integer typedefLine : includeFileWithTypedefLine) {
                    if (endLine < importLine || importLine < startLine || endLine < typedefLine || typedefLine < startLine || importLine >= typedefLine) continue;
                    return true;
                }
            }
            return false;
        }
        if (samePathPackageAndTypedef && !samePathPackageAndImport) {
            if (includeFileWithImportLine == null) {
                return false;
            }
            for (Integer importLine : includeFileWithImportLine) {
                if (endLine < importLine || importLine < startLine || importLine >= typedef.getTypedef().getOccurrence().getLine()) continue;
                return true;
            }
            return false;
        }
        if (!samePathPackageAndTypedef && samePathPackageAndImport) {
            if (includeFileWithTypedefLine == null) {
                return false;
            }
            for (Integer typedefLine : includeFileWithTypedefLine) {
                if (endLine < typedefLine || typedefLine < startLine || importStatement.getImportOperator().getOccurrence().getLine() >= typedefLine) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private RfPackage getPackageWithName(String name) {
        for (RfPackage localPackage : this.fOVMProject.getAllPackages()) {
            if (!name.equals(localPackage.getName())) continue;
            return localPackage;
        }
        return null;
    }

    private boolean isPrewaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class IHidVisitorImplementation
    implements IHidVisitor<IHidObject> {
        private final Map<RfPackage, List<PackageImportInfo>> importStatements = new HashMap<RfPackage, List<PackageImportInfo>>();
        private final Map<RfPackage, List<PackageTypedefInfo>> forwardTypedeffs = new HashMap<RfPackage, List<PackageTypedefInfo>>();
        private ParserPath parserPath;
        private RfPackage scopePackage;

        private IHidVisitorImplementation() {
        }

        public boolean visit(IHidObject hid) {
            if (this.scopePackage == null) {
                return true;
            }
            if (Check_R_1135.this.isPrewaived(this.parserPath)) {
                return true;
            }
            Check_R_1135.this.notifyCheckAlive();
            ParserPath packageParserPath = this.scopePackage.getDeclaration().getParserPath();
            if (hid instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hid;
                if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_IMPORT)) {
                    return true;
                }
                List<PackageImportInfo> localImports = this.importStatements.get(this.scopePackage);
                if (localImports == null) {
                    localImports = new ArrayList<PackageImportInfo>();
                    localImports.add(new PackageImportInfo(packageParserPath, this.parserPath, hidOperator));
                    this.importStatements.put(this.scopePackage, localImports);
                } else {
                    localImports.add(new PackageImportInfo(packageParserPath, this.parserPath, hidOperator));
                }
                return true;
            }
            if (hid instanceof RfHid) {
                RfHid rfHid = (RfHid)hid;
                if (!rfHid.hasOccurrence(HidQualifierCache.TYPEDEF_PROTOTYPE_QUALIFIER)) {
                    return true;
                }
                IRfNamedElement element = rfHid.getElement();
                if (!(element instanceof RfClass)) {
                    return true;
                }
                List<PackageTypedefInfo> localTypedeffs = this.forwardTypedeffs.get(this.scopePackage);
                if (localTypedeffs == null) {
                    localTypedeffs = new ArrayList<PackageTypedefInfo>();
                    localTypedeffs.add(new PackageTypedefInfo(this.parserPath, rfHid));
                    this.forwardTypedeffs.put(this.scopePackage, localTypedeffs);
                } else {
                    localTypedeffs.add(new PackageTypedefInfo(this.parserPath, rfHid));
                }
                return true;
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            super.setHolder(holder);
            RfNamedElement scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            this.scopePackage = scope.getEnclosingPackage();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public Map<RfPackage, List<PackageTypedefInfo>> getForwardTypedeffs() {
            return this.forwardTypedeffs;
        }

        public Map<RfPackage, List<PackageImportInfo>> getImportStatements() {
            return this.importStatements;
        }
    }

    private static class PackageImportInfo {
        ParserPath packageParserPath;
        ParserPath importParserPath;
        RfHidOperator importOperator;

        public PackageImportInfo(ParserPath packageParserPath, ParserPath importParserPath, RfHidOperator importOperator) {
            this.packageParserPath = packageParserPath;
            this.importParserPath = importParserPath;
            this.importOperator = importOperator;
        }

        public ParserPath getPackageParserPath() {
            return this.packageParserPath;
        }

        public ParserPath getImportParserPath() {
            return this.importParserPath;
        }

        public RfHidOperator getImportOperator() {
            return this.importOperator;
        }
    }

    private static class PackageTypedefInfo {
        ParserPath typedefParserPath;
        RfHid typedef;

        public PackageTypedefInfo(ParserPath typedefParserPath, RfHid typedef) {
            this.typedefParserPath = typedefParserPath;
            this.typedef = typedef;
        }

        public ParserPath getTypedefParserPath() {
            return this.typedefParserPath;
        }

        public RfHid getTypedef() {
            return this.typedef;
        }
    }
}

