/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.7")
@CheckID(value="R.1136")
@CheckName(value="R.1136")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.LOOP, RuleLabel.FOR, RuleLabel.FUNCTIONAL, RuleLabel.WIDTH_MISMATCH})
@CheckTitle(value="For-loop variable should be able to hold the loop threshold")
@CheckDescription(value="For-loop iteration variable width should not be smaller than for-loop variable data type threshold.\n\nExample:\nreg[3:0] i;\nfor (i=0; i<=15; i++) // not allowed - this will lead to infinite loop\n\nCheck supports pre-waiving.")
public class Check_R_1136
extends OVMComplianceCheck {
    private static final String HIT_MESSAGE_FORMAT_FOR_PARAMETERS = "For-loop iteration variable ''{0}'' width is smaller than the loop threshold {1} for instance:";
    private static final String HIT_MESSAGE_FORMAT = "For-loop iteration variable ''{0}'' width is smaller than the loop threshold {1}!";
    private Map<RfModule, Set<IndexElementWithContext>> indexElementsWithEnclosingModule = new HashMap<RfModule, Set<IndexElementWithContext>>();
    private Set<IndexElementWithContext> hitIndexElementsSet = new HashSet<IndexElementWithContext>();

    public Check_R_1136(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.indexElementsWithEnclosingModule.clear();
        this.hitIndexElementsSet.clear();
        ELManager elManager = this.fOVMProject.getRfProject().getELManager();
        List<RfActionBlock> allActionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : allActionBlocks) {
            int size;
            DVTNumber evaluateForSize;
            IRfNamedElement element;
            IHidObject loopHid;
            long loopThresHold;
            RfHidOperator loopCond;
            IHidObject loopCondOpi;
            IHidOperator loopOperator;
            List<IHidOperator> operators;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(actionBlock.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            if (!actionBlock.isFor() || (operators = actionBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_LOOP_EXPRESSION}, true)) == null || operators.size() != 1 || !((loopOperator = operators.get(0)) instanceof RfHidOperator) || !((loopCondOpi = loopOperator.getLHValue()) instanceof RfHidOperator) || !(loopCond = (RfHidOperator)loopCondOpi).isLessThanOrEqual() && !loopCond.isLessThan() || (loopThresHold = this.getLoopThresHold(loopCond)) == -1L || !((loopHid = loopCond.getLHValue()) instanceof RfHid) || !((element = ((RfHid)loopHid).getElement()) instanceof RfField)) continue;
            RfModule enclosingModule = (RfModule)element.getEnclosingScope(RfModule.class);
            if (enclosingModule != null) {
                if (!this.indexElementsWithEnclosingModule.containsKey(enclosingModule)) {
                    this.indexElementsWithEnclosingModule.put(enclosingModule, new HashSet());
                }
                Set<IndexElementWithContext> set = this.indexElementsWithEnclosingModule.get(enclosingModule);
                set.add(new IndexElementWithContext(actionBlock, (RfHid)loopHid, loopThresHold, loopCond.isLessThanOrEqual()));
                this.indexElementsWithEnclosingModule.put(enclosingModule, set);
                continue;
            }
            ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(elManager);
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, null, (boolean)true, (ELManager)elManager);
            guardian.updateElements(element, (IRfNamedElement)enclosingModule);
            ELParamValueScope forSizeValue = ELUtils.evaluateForSize((IHidObject)loopHid, (IHidEvaluator)evaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardian);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)forSizeValue) || DVTNumber.isUndefined((DVTNumber)(evaluateForSize = forSizeValue.getDVTNumber())) || (size = evaluateForSize.getSize()) >= 63) continue;
            long dataTypeThresHold = (1L << size) - 1L;
            boolean isLessThanOrEqual = loopCond.isLessThanOrEqual();
            if ((!isLessThanOrEqual || loopThresHold < dataTypeThresHold) && (isLessThanOrEqual || loopThresHold <= dataTypeThresHold)) continue;
            this.addHit(actionBlock, MessageFormat.format(HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName((RfField)element), loopThresHold));
        }
        this.checkAllIndexElementsCollected();
        if (this.hitIndexElementsSet != null && !this.hitIndexElementsSet.isEmpty()) {
            for (IndexElementWithContext indexElement : this.hitIndexElementsSet) {
                this.addHit(indexElement.getActionBlock(), indexElement.getHitMessage());
            }
        }
    }

    private void checkAllIndexElementsCollected() {
        final ELManager elManager = this.fOVMProject.getRfProject().getELManager();
        if (elManager == null) {
            return;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return;
        }
        final Set<RfModule> enclosingModules = this.indexElementsWithEnclosingModule.keySet();
        if (enclosingModules == null || enclosingModules.isEmpty()) {
            return;
        }
        memory.visitBindings(new IELMemory.IELMemoryVisitor(){

            public boolean visitBindings(ElementPath path, ELInstance instance) {
                IRfNamedElement binding = instance.getBinding(false);
                if (!enclosingModules.contains(binding)) {
                    return true;
                }
                ELParamValues paramValues = instance.getParamValues();
                ELParamValuesHidEvaluator evaluator = paramValues.getHidEvaluator(elManager);
                Set<IndexElementWithContext> indexElements = Check_R_1136.this.indexElementsWithEnclosingModule.get(binding);
                for (IndexElementWithContext indexElement : indexElements) {
                    int size;
                    DVTNumber evaluateForSize;
                    IHidEvaluationGuardian guardian;
                    IRfNamedElement element;
                    RfHid loopHid = indexElement.getLoopHid();
                    ELParamValueScope forSize = ELUtils.evaluateForSize((IHidObject)loopHid, (IHidEvaluator)evaluator, (IRfNamedElement)(element = loopHid.getElement()), (IHidEvaluationGuardian)(guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, (ElementPath)path, (boolean)true, (ELManager)elManager)));
                    if (ELUtils.isUnsuccessfulEval((ELParamValueScope)forSize) || DVTNumber.isUndefined((DVTNumber)(evaluateForSize = forSize.getDVTNumber())) || (size = evaluateForSize.getSize()) >= 63) continue;
                    long dataTypeThresHold = (1L << size) - 1L;
                    boolean isLessThanOrEqual = indexElement.isLessThanOrEqual();
                    long loopThresHold = indexElement.getLoopThresHold();
                    if ((!isLessThanOrEqual || loopThresHold < dataTypeThresHold) && (isLessThanOrEqual || loopThresHold <= dataTypeThresHold)) continue;
                    if (instance.getDescription() instanceof DummyInstance) {
                        indexElement.appendToSb(MessageFormat.format(Check_R_1136.HIT_MESSAGE_FORMAT, LintUtils.getNamedElementFullName((RfNamedElement)element), loopThresHold));
                    } else if (indexElement.isSbEmpty()) {
                        indexElement.appendToSb(MessageFormat.format(Check_R_1136.HIT_MESSAGE_FORMAT_FOR_PARAMETERS, LintUtils.getNamedElementFullName((RfNamedElement)element), loopThresHold));
                        indexElement.appendToSb(Check_R_1136.this.addLineFileInfo((RfNamedElement)instance.getDescription(), "\n" + LintUtils.getNamedElementFullName((RfNamedElement)instance.getDescription()) + " "));
                    } else {
                        indexElement.appendToSb(Check_R_1136.this.addLineFileInfo((RfNamedElement)instance.getDescription(), "\n" + LintUtils.getNamedElementFullName((RfNamedElement)instance.getDescription()) + " "));
                    }
                    if (Check_R_1136.this.hitIndexElementsSet.contains(indexElement)) continue;
                    Check_R_1136.this.hitIndexElementsSet.add(indexElement);
                }
                return true;
            }
        });
    }

    private long getLoopThresHold(RfHidOperator loopCond) {
        ListContainer rhValues = loopCond.getRHValues();
        if (!(rhValues instanceof RfHidImplicit)) {
            return -1L;
        }
        Number numberValue = ((RfHidImplicit)rhValues).parseNumberValue();
        if (numberValue == null) {
            return -1L;
        }
        return numberValue.longValue();
    }

    private static class IndexElementWithContext {
        private RfActionBlock actionBlock;
        private RfHid loopHid;
        private long loopThresHold;
        private boolean lessThanOrEqual;
        private StringBuilder sb;

        public IndexElementWithContext(RfActionBlock actionBlock, RfHid loopHid, long loopThresHold, boolean lessThanOrEqual) {
            this.actionBlock = actionBlock;
            this.loopHid = loopHid;
            this.loopThresHold = loopThresHold;
            this.lessThanOrEqual = lessThanOrEqual;
            this.sb = new StringBuilder();
        }

        public RfActionBlock getActionBlock() {
            return this.actionBlock;
        }

        public RfHid getLoopHid() {
            return this.loopHid;
        }

        public long getLoopThresHold() {
            return this.loopThresHold;
        }

        public boolean isLessThanOrEqual() {
            return this.lessThanOrEqual;
        }

        public void appendToSb(String str) {
            this.sb.append(str);
        }

        public boolean isSbEmpty() {
            return this.sb.length() == 0;
        }

        public String getHitMessage() {
            return this.sb.toString();
        }
    }
}

