/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="22.1.8")
@CheckID(value="R.1137")
@CheckName(value="R.1137")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CONSTRAINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use only variables that cannot be randomized in randomize with constraints")
@CheckDescription(value="This check flags variables used in randomize with constraints that are not declared as randomizable or are not part of the randomized object.\n\nImplementation details:\nIf there's at least one randomizable variable that is part of the randomized object in the constraint, the constraint will be ignored.\n\nCheck supports pre-waiving.")
public class Check_R_1137
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, variables used in conditional expressions (if statements, implications and ternary operators) will be ignored.", name="skipConditionalExpressions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipConditionalExpressions;
    private Set<Integer> conditionalExpressionOperatorTypes;

    public Check_R_1137(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.conditionalExpressionOperatorTypes = new HashSet<Integer>(Arrays.asList(534, 499, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id));
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RandomizeVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class RandomizeVisitor
    extends RfHidVisitor {
        private IRfNamedElement scope;

        RandomizeVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHid hidObject) {
            if (Check_R_1137.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!hidObject.getName().equals("randomize")) {
                return true;
            }
            if (!(hidObject.getParentAccess() instanceof RfHidAccess)) {
                return true;
            }
            if (!(hidObject.getParentHid() instanceof RfHid)) {
                return true;
            }
            RfHid parentHid = (RfHid)hidObject.getParentHid();
            if (parentHid.hasQualifier(HidQualifierCache.HIDDEN)) {
                return true;
            }
            if (!(parentHid.getElement() instanceof RfField)) {
                return true;
            }
            RfField randomizedField = (RfField)parentHid.getElement();
            RfNamedElement randomizedFieldType = LintUtils.getAssociatedFinalType(randomizedField);
            if (!(randomizedFieldType instanceof RfClass)) {
                return true;
            }
            if (!hidObject.hasAccesses() || !(hidObject.getFirstAccess() instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs access = (RfHidAccessArgs)hidObject.getFirstAccess();
            if (!access.hasWithClause() || !(access.getWithClause() instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator withClause = (RfHidOperator)access.getWithClause();
            if (!(withClause.getLHValue() instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator constraint = (RfHidOperator)withClause.getLHValue();
            IHidObject lhValue = constraint.getLHValue();
            HashSet<RfHid> invalidHids = new HashSet<RfHid>();
            if (lhValue instanceof RfHidImplicit && ((RfHidImplicit)lhValue).getName().equals("{")) {
                ListContainer rhValues = constraint.getRHValues();
                for (IHidObject rhValue : rhValues) {
                    Set<RfHid> invalidHidsOnOperator;
                    if (!(rhValue instanceof RfHidOperator) || (invalidHidsOnOperator = this.checkOperator((RfHidOperator)rhValue, randomizedField)) == null) continue;
                    invalidHids.addAll(invalidHidsOnOperator);
                }
            } else {
                Set<RfHid> invalidHidsOnOperator = this.checkOperator(withClause, randomizedField);
                if (invalidHidsOnOperator != null) {
                    invalidHids.addAll(invalidHidsOnOperator);
                }
            }
            for (RfHid invalidHid : invalidHids) {
                Check_R_1137.this.addHit(this.parserPath, invalidHid.getLine(), "Variable '" + invalidHid.getName() + "' is used in randomize with constraint of '" + randomizedField.getName() + "' and it cannot be randomized!", (ReparseInfo)invalidHid.getReparseInfo(), true);
            }
            return true;
        }

        private Set<RfHid> checkOperator(RfHidOperator operator, RfField randomizedField) {
            IHidObject lhValue = operator.getLHValue();
            HashSet<RfHid> invalidHids = new HashSet<RfHid>();
            boolean valid = false;
            if (!Check_R_1137.this.pSkipConditionalExpressions || !Check_R_1137.this.conditionalExpressionOperatorTypes.contains(operator.getOperatorType())) {
                if (lhValue instanceof RfHidOperator) {
                    Set<RfHid> invalidHidsOnOperator = this.checkOperator((RfHidOperator)lhValue, randomizedField);
                    if (invalidHidsOnOperator == null) {
                        valid = true;
                    } else {
                        invalidHids.addAll(invalidHidsOnOperator);
                    }
                } else if (lhValue instanceof RfHidAccess) {
                    RfHidAccess access = (RfHidAccess)lhValue;
                    if (access.getParentHid() instanceof RfHid && !(valid = this.checkHid((RfHid)access.getParentHid(), randomizedField))) {
                        invalidHids.add((RfHid)access.getParentHid());
                    }
                } else if (lhValue instanceof RfHid && !(valid = this.checkHid((RfHid)lhValue, randomizedField))) {
                    invalidHids.add((RfHid)lhValue);
                }
            }
            if (valid) {
                return null;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null) {
                return invalidHids;
            }
            for (IHidObject rhValue : rhValues) {
                if (valid) {
                    return null;
                }
                if (rhValue instanceof RfHidOperator) {
                    Set<RfHid> invalidHidsOnOperator = this.checkOperator((RfHidOperator)rhValue, randomizedField);
                    if (invalidHidsOnOperator == null) {
                        valid = true;
                        continue;
                    }
                    invalidHids.addAll(invalidHidsOnOperator);
                    continue;
                }
                if (rhValue instanceof RfHidAccess) {
                    RfHidAccess access = (RfHidAccess)rhValue;
                    if (!(access.getParentHid() instanceof RfHid) || (valid = this.checkHid((RfHid)access.getParentHid(), randomizedField))) continue;
                    invalidHids.add((RfHid)access.getParentHid());
                    continue;
                }
                if (!(rhValue instanceof RfHid) || (valid = this.checkHid((RfHid)rhValue, randomizedField))) continue;
                invalidHids.add((RfHid)rhValue);
            }
            return valid ? null : invalidHids;
        }

        private boolean checkHid(RfHid rfHid, RfField randomizedField) {
            if ((rfHid.getElement() instanceof RfPredefinedField || rfHid.getElement() instanceof RfPredefinedFunction) && rfHid.getParentAccess() instanceof RfHidAccess && rfHid.getParentHid() instanceof RfHid) {
                rfHid = (RfHid)rfHid.getParentHid();
            }
            if (!(rfHid.getElement() instanceof RfField)) {
                return false;
            }
            IRfNamedElement field = rfHid.getElement();
            while (field instanceof RfField) {
                if (!field.isRand() && !((RfField)field).isRandc()) {
                    return false;
                }
                if (!(rfHid.getParentAccess() instanceof RfHidAccess) || !(rfHid.getParentHid() instanceof RfHid) || !((rfHid = (RfHid)rfHid.getParentHid()).getElement() instanceof RfField) || rfHid.getElement().checkEquals((Object)randomizedField)) break;
                field = rfHid.getElement();
            }
            RfField constrainedField = (RfField)field;
            RfNamedElement randomizedFieldType = LintUtils.getAssociatedFinalType(randomizedField, RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 6));
            HashSet<RfField> fieldSet = new HashSet<RfField>(randomizedFieldType.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            if (!fieldSet.contains(constrainedField)) {
                return false;
            }
            return constrainedField.isRand() || constrainedField.isRandc();
        }
    }
}

