/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="22.1.7")
@CheckID(value="R.1138")
@CheckName(value="R.1138")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.VERIFICATION, RuleLabel.SEQUENCER})
@CheckTitle(value="Do not use uvm_sequencer_base.default_sequence configuration parameter to start sequences")
@CheckDescription(value="This check flags assignments and method calls of the uvm_sequencer_base.default_sequence field.\nuvm-1.2 recommends using the class uvm_sequence_library if you want to start sequences at the beginning of a phase.\nThis can be a useful technique for starting background traffic on a sequencer, but calling the start method should be used as the primary way of starting sequences.\n\nExamples:\nclass my_sequencer extends uvm_sequencer;\n  function foo();\n    default_sequence = \"my_sequence\"; //not allowed\n    my_sequence.start(m_sequencer, this); // allowed\n  endfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1138
extends OVMComplianceCheck {
    private static final String DEFAULT_SEQUENCE_STRING = "default_sequence";
    private static final String SEQUENCER_BASE_CLASS_NAME = "uvm_pkg::uvm_sequencer_base";
    private RfClass sequencerBaseClass;

    public Check_R_1138(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.isOVMLib()) {
            return;
        }
        this.sequencerBaseClass = this.fOVMProject.getRfProject().getClass(SEQUENCER_BASE_CLASS_NAME, true);
        if (this.sequencerBaseClass == null) {
            return;
        }
        Set<RfClass> allSequencers = this.fOVMProject.getAllXVMSubClasses(this.sequencerBaseClass);
        HashSet<RfClass> allClasses = new HashSet<RfClass>(Arrays.asList(this.fOVMProject.getRfProject().getAllClasses()));
        allClasses.removeAll(allSequencers);
        for (RfClass clazz : allSequencers) {
            this.notifyCheckAlive();
            if (this.checkPrewaivers(clazz.getDeclaration().getParserPath())) continue;
            clazz.visitHidObject(this.fOVMProject.getRfProject(), new LocalAssignmentVisitor());
            clazz.visitHidObject(this.fOVMProject.getRfProject(), new LocalMethodCallVisitor());
        }
        for (RfClass clazz : allClasses) {
            this.notifyCheckAlive();
            if (this.checkPrewaivers(clazz.getDeclaration().getParserPath())) continue;
            clazz.visitHidObject(this.fOVMProject.getRfProject(), new LocalMethodCallVisitor());
        }
    }

    private void handleMethodCall(MethodCall call, ParserPath parserPath) {
        if (call.argumentValuesMap == null || call.argumentValuesMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : call.argumentValuesMap.entrySet()) {
            RfField argument;
            IRfNamedElement key = (IRfNamedElement)entry.getKey();
            if (!(key instanceof RfField) || !this.isWrittenArgument(argument = (RfField)key)) continue;
            Set values = (Set)entry.getValue();
            for (IHid value : values) {
                RfField field;
                if (!(value instanceof RfHid) || !(value.getElement() instanceof RfField) || !this.isDefaultSequenceField(field = (RfField)value.getElement())) continue;
                this.addHit(parserPath, call.getOccurrence(), "The 'default_sequence' configuration parameter is written in the '" + call.getMethodName() + "' method call!");
                return;
            }
        }
    }

    public void handleSetMethodCall(MethodCall call, ParserPath parserPath) {
        if (call.argumentValuesMap == null || call.argumentValuesMap.isEmpty()) {
            return;
        }
        if (call.argumentValuesMap.size() != 4) {
            return;
        }
        for (Map.Entry entry : call.argumentValuesMap.entrySet()) {
            RfField argument;
            IRfNamedElement key = (IRfNamedElement)entry.getKey();
            if (!(key instanceof RfField) || !"field_name".equals((argument = (RfField)key).getName())) continue;
            Set values = (Set)entry.getValue();
            for (IHid value : values) {
                RfHidImplicit hidImplicit;
                if (!(value instanceof RfHidImplicit) || !DEFAULT_SEQUENCE_STRING.equals(DVTStringUtil.unquote((String)(hidImplicit = (RfHidImplicit)value).getName()))) continue;
                this.addHit(parserPath, call.getOccurrence(), "The 'default_sequence' configuration parameter is written in the '" + call.getMethodName() + "' method call!");
                return;
            }
        }
    }

    private boolean isWrittenArgument(RfField argument) {
        return argument.isOutput() || argument.isRef() && !argument.isConstRef() || argument.isInout();
    }

    private boolean isDefaultSequenceField(RfField field) {
        if (!DEFAULT_SEQUENCE_STRING.equals(field.getName())) {
            return false;
        }
        RfClass enclosingScope = field.getEnclosingScope(RfClass.class);
        if (enclosingScope == null) {
            return false;
        }
        return this.sequencerBaseClass.equals(enclosingScope);
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LocalAssignmentVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        LocalAssignmentVisitor() {
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (hidOperator == null) {
                return true;
            }
            if (this.scope.isPredefined()) {
                return true;
            }
            if (!hidOperator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            IRfNamedElement element = ((RfHid)lhValue).getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            if (!Check_R_1138.this.isDefaultSequenceField(field)) {
                return true;
            }
            Check_R_1138.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "The 'default_sequence' configuration parameter is written!");
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }

    class LocalMethodCallVisitor
    extends RfHidVisitor {
        RfNamedElement scope;

        LocalMethodCallVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (this.scope.isPredefined()) {
                return true;
            }
            if (Check_R_1138.this.fOVMProject.isOVMElement(this.scope)) {
                return true;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            boolean isSetMethodCall = false;
            if ("set".equals(hidObject.getName()) && hidObject.getElement() instanceof RfFunction) {
                isSetMethodCall = "uvm_pkg::uvm_config_db.set".equals(((RfFunction)hidObject.getElement()).getFullName());
            }
            for (MethodCall call : methodCalls) {
                if (isSetMethodCall) {
                    Check_R_1138.this.handleSetMethodCall(call, this.parserPath);
                    continue;
                }
                Check_R_1138.this.handleMethodCall(call, this.parserPath);
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

