/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="22.1.11")
@CheckID(value="R.1139")
@CheckName(value="R.1139")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Multiline statement formatting")
@CheckDescription(value="When a statement is longer than <maxNofChars>, moving it to a new line should meet the following conditions:\n1) The new line should have <nofSpaces> space indentation w.r.t to the first line;\n2) The operator should be placed at end of the line;\n3) If the statement is a function declaration, there shouldn't be any indentation before \");\"\n\nExamples:\nif (\n  (xx_has_a_lot_of_characters_exceeds_col_limit == yy) && // allowed\n  (aa == bb) // allowed\n) begin\n\nif (\n  (xx_has_a_lot_of_characters_exceeds_col_limit == yy)\n  && (aa == bb) // not allowed\n    (aa == cc) // not allowed\n) begin\n\nfunction void my_class::foo(\n  int foo\n  ); // not allowed\n\nfunction void my_class::foo(\n  int foo\n); // allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_R_1139
extends AbstractSVTBSimpleIssues
implements IWhitespaceParserCheck {
    private static final Set<String> oneCharOp = new HashSet<String>();
    private static final Set<String> twoCharOp = new HashSet<String>();
    private static final Set<String> threeCharOp = new HashSet<String>();
    private static final Set<String> fourCharOp = new HashSet<String>();
    private static final Set<String> skipBlocks = new HashSet<String>();
    @CheckParameter(defaultValue="100", description="Threshold number of characters in a statement to be analyzed.", name="maxNofChars", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pMaxNofChars;
    @CheckParameter(defaultValue="2", description="The number of spaces used for indentation of multi-line statements.", name="nofSpaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pNofSpaces;

    static {
        oneCharOp.add("=");
        oneCharOp.add("+");
        oneCharOp.add("-");
        oneCharOp.add("*");
        oneCharOp.add("/");
        oneCharOp.add("<");
        oneCharOp.add(">");
        oneCharOp.add("&");
        oneCharOp.add("|");
        oneCharOp.add("^");
        twoCharOp.add("+=");
        twoCharOp.add("-=");
        twoCharOp.add("*=");
        twoCharOp.add("/=");
        twoCharOp.add("%=");
        twoCharOp.add("&=");
        twoCharOp.add("|=");
        twoCharOp.add("^=");
        twoCharOp.add("==");
        twoCharOp.add("!=");
        twoCharOp.add("&&");
        twoCharOp.add("||");
        twoCharOp.add("**");
        twoCharOp.add("<=");
        twoCharOp.add(">=");
        twoCharOp.add("^~");
        twoCharOp.add("~^");
        twoCharOp.add(">>");
        twoCharOp.add("<<");
        twoCharOp.add("->");
        threeCharOp.add("<<=");
        threeCharOp.add(">>=");
        threeCharOp.add("===");
        threeCharOp.add("!==");
        threeCharOp.add("==?");
        threeCharOp.add("!=?");
        threeCharOp.add(">>>");
        threeCharOp.add("<<<");
        threeCharOp.add("<->");
        fourCharOp.add("<<<=");
        fourCharOp.add(">>>=");
        skipBlocks.add("fork");
        skipBlocks.add("join");
        skipBlocks.add("join_any");
        skipBlocks.add("join_none");
        skipBlocks.add("begin");
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(114);
    }

    public Check_R_1139(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return null;
    }

    @Override
    public void performCheckImpl() {
        String op;
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(114);
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            ParserPath path = entry.getKey();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this)) continue;
            this.notifyCheckAlive();
            List<SVTBIssues> issues = entry.getValue();
            Iterator<SVTBIssues> iterator = issues.iterator();
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFile(path);
            if (fileDef == null) continue;
            SVTBIssues currentIssue = null;
            SVTBIssues nextIssue = null;
            if (!iterator.hasNext()) continue;
            currentIssue = iterator.next();
            while (currentIssue != null) {
                int startLineNo;
                LiteralToken tokenOfNextSVTBIssue = null;
                if (iterator.hasNext()) {
                    nextIssue = iterator.next();
                    tokenOfNextSVTBIssue = this.getWSParser().getTokenContainingOffset(nextIssue.getOffset(), path);
                } else {
                    nextIssue = null;
                }
                if (currentIssue.getReparseInfo() != null) {
                    currentIssue = nextIssue;
                    continue;
                }
                LiteralToken currentToken = this.getWSParser().getTokenContainingOffset(currentIssue.getOffset(), path);
                if (currentToken == null) {
                    currentIssue = nextIssue;
                    continue;
                }
                if (skipBlocks.contains(currentIssue.getInfo())) {
                    currentIssue = nextIssue;
                    continue;
                }
                int endLineNo = startLineNo = currentToken.getLineNumber();
                int statementLength = currentToken.getOffsetLine();
                LiteralToken firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(path, endLineNo);
                int statementIndentation = firstTokenOnLine != null ? firstTokenOnLine.getNoSpacesBefore() : currentToken.getNoSpacesBefore();
                LiteralToken firstToken = currentToken;
                LiteralToken nextToken = currentToken;
                while (this.checkCurrentToken(currentToken, nextToken, tokenOfNextSVTBIssue)) {
                    currentToken = nextToken;
                    nextToken = this.getWSParser().getNextToken(currentToken, path);
                    if (nextToken == null) break;
                    statementLength = currentToken.getLineNumber() == nextToken.getLineNumber() ? (statementLength += nextToken.getOffsetLine() - currentToken.getOffsetLine()) : (statementLength += currentToken.getLength());
                    endLineNo = currentToken.getLineNumber();
                }
                if (startLineNo == endLineNo || statementLength < this.pMaxNofChars) {
                    currentIssue = nextIssue;
                    continue;
                }
                if (firstToken.getNoTabsBefore() != 0) {
                    this.addHit(path, firstToken.getLineNumber(), "Tabs cannot be used for indentation!", null);
                    currentIssue = nextIssue;
                    continue;
                }
                if (currentToken.isFirstTokenOnLine()) {
                    if (this.isWrongIndentation(currentToken, statementIndentation, true)) {
                        this.addHit(path, currentToken.getLineNumber(), "Wrong indentation at the start of the line!", null);
                    }
                    if (this.isEndParenthesis(currentToken)) {
                        --endLineNo;
                    }
                } else {
                    statementLength += currentToken.getLength();
                }
                int currentLineNo = startLineNo + 1;
                while (currentLineNo <= endLineNo) {
                    firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(path, currentLineNo);
                    if (firstTokenOnLine != null && !this.isInRandomize(fileDef, firstTokenOnLine)) {
                        if (firstTokenOnLine.getNoTabsBefore() != 0) {
                            this.addHit(path, firstTokenOnLine.getLineNumber(), "Tabs cannot be used for indentation!", null);
                        } else {
                            if (this.isWrongIndentation(firstTokenOnLine, statementIndentation, false)) {
                                this.addHit(path, currentLineNo, "Wrong indentation at the start of the line!", null);
                            }
                            if ((op = this.isOperator(firstTokenOnLine)) != null) {
                                this.addHit(path, currentLineNo, "The '" + op + "' operator cannot be placed at the start of the line!", null);
                            }
                        }
                    }
                    ++currentLineNo;
                }
                currentIssue = nextIssue;
            }
        }
        NullProtectedList<RfNamedElement> allFunctionsAndTasks = new NullProtectedList<RfNamedElement>();
        allFunctionsAndTasks.addAll(this.fOVMProject.getAllFunctions());
        allFunctionsAndTasks.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement method : allFunctionsAndTasks) {
            Collection declarations = method.getDeclarations();
            for (RfDefElement declaration : declarations) {
                int startLineNo;
                if (declaration == null || declaration.getReparseInfo() != null) continue;
                ParserPath path = declaration.getParserPath();
                if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this)) continue;
                this.notifyCheckAlive();
                int line = declaration.getStartLine();
                LiteralToken currentToken = this.getWSParser().getFirstTokenOnLine(path, line);
                if (currentToken == null) continue;
                int endLineNo = startLineNo = currentToken.getLineNumber();
                int statementLength = currentToken.getOffsetLine();
                int statementIndentation = currentToken.getNoSpacesBefore();
                LiteralToken firstToken = currentToken;
                LiteralToken prevToken = currentToken;
                while ((currentToken = this.getWSParser().getNextToken(currentToken, path)) != null) {
                    if (currentToken.getLineNumber() == prevToken.getLineNumber()) {
                        statementLength += currentToken.getOffsetLine() - prevToken.getOffsetLine();
                    } else {
                        statementLength += prevToken.getLength();
                        endLineNo = currentToken.getLineNumber();
                    }
                    prevToken = currentToken;
                    if (this.checkCurrentToken(currentToken)) continue;
                }
                if (currentToken == null || (statementLength += currentToken.getLength()) < this.pMaxNofChars) continue;
                if (firstToken.getNoTabsBefore() != 0) {
                    this.addHit(path, firstToken.getLineNumber(), "Tabs cannot be used for indentation!", null);
                    continue;
                }
                int currentLineNo = startLineNo + 1;
                while (currentLineNo <= endLineNo) {
                    LiteralToken firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(path, currentLineNo);
                    if (firstTokenOnLine != null) {
                        if (firstTokenOnLine.getNoTabsBefore() != 0) {
                            this.addHit(path, firstTokenOnLine.getLineNumber(), "Tabs cannot be used for indentation!", null);
                        } else {
                            boolean isLastLine;
                            boolean bl = isLastLine = currentLineNo == endLineNo;
                            if (this.isWrongIndentation(firstTokenOnLine, statementIndentation, isLastLine)) {
                                this.addHit(path, currentLineNo, "Wrong indentation at the start of the line!", null);
                            }
                            if ((op = this.isOperator(firstTokenOnLine)) != null) {
                                this.addHit(path, currentLineNo, "The '" + op + "' operator cannot be placed at the start of the line!", null);
                            }
                        }
                    }
                    ++currentLineNo;
                }
            }
        }
    }

    private boolean checkCurrentToken(LiteralToken token) {
        if (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE)) {
            return false;
        }
        return !token.getStringToken().contains(";");
    }

    private boolean checkCurrentToken(LiteralToken currentToken, LiteralToken nextToken, LiteralToken tokenToStop) {
        if (currentToken == null || nextToken == null) {
            return false;
        }
        if (currentToken.getStringToken().contains(";")) {
            return false;
        }
        if (nextToken.equals(tokenToStop)) {
            return false;
        }
        return nextToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE);
    }

    private boolean isWrongIndentation(LiteralToken literalToken, int statementIndentation, boolean isLastToken) {
        if (isLastToken && this.isEndParenthesis(literalToken)) {
            return literalToken.getNoSpacesBefore() != statementIndentation;
        }
        return literalToken.getNoSpacesBefore() - this.pNofSpaces != statementIndentation;
    }

    private boolean isEndParenthesis(LiteralToken token) {
        HashSet<Character> endParenthesis = new HashSet<Character>(Arrays.asList(Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}')));
        return endParenthesis.contains(Character.valueOf(token.getStringToken().charAt(0)));
    }

    private String isOperator(LiteralToken literalToken) {
        String token = literalToken.getStringToken();
        if (token == null || token.isEmpty()) {
            return null;
        }
        if (token.length() >= 4) {
            for (String op : fourCharOp) {
                if (!token.startsWith(op)) continue;
                return op;
            }
        }
        if (token.length() >= 3) {
            for (String op : threeCharOp) {
                if (!token.startsWith(op)) continue;
                return op;
            }
        }
        if (token.length() >= 2) {
            for (String op : twoCharOp) {
                if (!token.startsWith(op)) continue;
                return op;
            }
        }
        if (token.length() >= 1) {
            for (String op : oneCharOp) {
                if (!token.startsWith(op)) continue;
                return op;
            }
        }
        return null;
    }

    private boolean isInRandomize(RfFileDef fileDef, LiteralToken tokenOnLine) {
        RfDefElement defScope = fileDef.getScope(tokenOnLine.getOffsetFile(), true);
        if (!(defScope instanceof RfActionBlockDef)) {
            return false;
        }
        RfActionBlock block = (RfActionBlock)((RfActionBlockDef)defScope).getNamedElement();
        RfNamedElement enclosingScope = block.getEnclosingScope();
        if (!(enclosingScope instanceof RfFunctionCall)) {
            return false;
        }
        RfFunctionCall call = (RfFunctionCall)enclosingScope;
        return call.hasWith();
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return null;
    }
}

