/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

@CheckVersion(value="22.1.9")
@CheckID(value="R.1140")
@CheckName(value="R.1140")
@CheckLabel(labels={RuleLabel.BANNED_API})
@CheckTitle(value="Do not use banned patterns")
@CheckDescription(value="This check flags lines with used banned patterns.\n\nCheck supports pre-waiving.")
public class Check_R_1140
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of banned patterns. Multi-line patterns are not checked.", name="bannedPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pBannedPatterns;

    public Check_R_1140(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pBannedPatterns.isEmpty()) {
            return;
        }
        BufferedReader reader = null;
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath parserPath : files) {
            if (parserPath.path.indexOf("__vlog__") != -1 || this.checkPreWaivers(parserPath)) continue;
            this.notifyCheckAlive();
            try {
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(parserPath.path));
                    int lineNo = 0;
                    while ((line = reader.readLine()) != null) {
                        ++lineNo;
                        for (Pattern pattern : this.pBannedPatterns) {
                            Matcher matcher = pattern.matcher(line);
                            while (matcher.find()) {
                                this.addHit(parserPath, lineNo, "Banned pattern '" + pattern.pattern() + "' used on line at offset " + matcher.start() + "!", null);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        this.fOVMProject.notifyCheckException(this, e2);
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        this.fOVMProject.notifyCheckException(this, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                throw throwable;
            }
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

